/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.ContentPanel;
import com.vmware.vide.dashboard.peweb.Activator;
import com.vmware.vide.dashboard.peweb.CertWaiverService;
import com.vmware.vide.dashboard.peweb.waivers.ReleaseData;
import com.vmware.vide.dashboard.peweb.waivers.TestData;
import com.vmware.vide.dashboard.peweb.waivers.WaiverData;
import com.vmware.vide.dashboard.peweb.waivers.WaiversByCompType;
import com.vmware.vide.dashboard.peweb.waivers.WaiversList;
import com.vmware.vide.utils.local.VMWBConfig;
import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.utils.xml.JaxbUtils;
import com.vmware.vide.utils.xml.XMLParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WaiversPanel
extends ContentPanel {
    String content;
    public static final String LINK_PREFIX = "vide:peweb/waivers";
    public static final String LINK_LIST_WAIVERS = "vide:peweb/waivers/waivers/list";
    public static final String LINK_LIST_WAIVERS_DESCR = "Global Certification Waivers";
    public static final String LINK_WAIVERS_PRODUCT = "vide:peweb/waivers/waivers_compType?";
    public static final String LINK_WAIVERS_PRODUCT_DESCR = "Product Types";
    public static final String LINK_WAIVER_DETAILS = "vide:peweb/waivers/waiver_details?";
    public static final String LINK_WAIVER_DETAILS_DESCR = "Waiver Details";
    public static final String LINK_WAIVERSPECS = "/waivers?cert";
    public static final String LINK_WAIVERSPECS_HOME = "/waivers?home";
    public static final String LINK_WAIVERS = "/waivers?";
    private static final String WAIVERS_FILE_NAME = "waivers.xml";
    private static final String WAIVERS_FILE_PATH = "waiversFilePath";
    private static final String WAIVERS_DEFAULT_DIR = "/opt/vmware/waivers/";
    private String waiversFile;
    private Map<String, WaiverData> waiverArtifacts;
    private Map<String, List<WaiverData>> waiversByCompType;
    String currentPage;

    public boolean init() {
        super.init();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.waiversFile = store.getString(WAIVERS_FILE_PATH);
        return true;
    }

    public String getHeader() {
        return LINK_LIST_WAIVERS_DESCR;
    }

    public String getWaiversFile() {
        return this.waiversFile;
    }

    public void setWaiversFile(String filePath) {
        this.waiversFile = filePath;
    }

    public String getLinkDescription(String link) {
        if (link.startsWith(LINK_WAIVERS_PRODUCT)) {
            int index = link.indexOf("?");
            String descr = link.substring(++index);
            try {
                descr = URLDecoder.decode(descr, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                descr = LINK_WAIVERS_PRODUCT_DESCR;
            }
            return descr;
        }
        if (link.startsWith(LINK_LIST_WAIVERS) || link.equals(this.getPrefix())) {
            return LINK_LIST_WAIVERS_DESCR;
        }
        if (link.startsWith(LINK_WAIVER_DETAILS)) {
            return LINK_WAIVER_DETAILS_DESCR;
        }
        return super.getLinkDescription(link);
    }

    protected String getWaiverHomeHTML() {
        StringBuilder msg = new StringBuilder();
        msg.append("<a href=\"");
        msg.append(String.valueOf(this.getPrefix()) + LINK_WAIVERSPECS_HOME);
        msg.append("\">");
        msg.append("Download");
        msg.append("</a>&nbsp;");
        msg.append("and ");
        msg.append("<a href=\"");
        msg.append(LINK_LIST_WAIVERS);
        msg.append("\">");
        msg.append("display");
        msg.append("</a>&nbsp;");
        msg.append("Global Certification Waivers.<br/><br/>");
        return msg.toString();
    }

    private Job getWaiverDownloader(final String waiverFilePath, final boolean allowViewing) {
        Job downloader = new Job("Retrieving waivers..."){

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                block36: {
                    FilterOutputStream output;
                    block39: {
                        BufferedInputStream reader = null;
                        output = null;
                        try {
                            HttpLogger.logActivity((String)"testmgr", null, (String)"Dashboard", (String)"WaiversDownload");
                            WaiversList waiversList = CertWaiverService.getGlobalWaivers();
                            File downloadDir = new File(waiverFilePath).getParentFile();
                            if (!downloadDir.exists()) {
                                downloadDir.mkdirs();
                            }
                            output = new BufferedOutputStream(new FileOutputStream(waiverFilePath));
                            JaxbUtils.toPrettyXml(WaiversList.class, (OutputStream)output, (Object)waiversList, (boolean)false);
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (IOException iOException) {}
                            }
                            monitor.done();
                            break block36;
                        }
                        catch (IOException e) {
                            block37: {
                                e.printStackTrace();
                                if (reader == null) break block37;
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (IOException iOException) {}
                            }
                            monitor.done();
                            break block36;
                        }
                        catch (Exception e) {
                            block38: {
                                e.printStackTrace();
                                if (reader == null) break block38;
                                {
                                    catch (Throwable throwable) {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (output != null) {
                                            try {
                                                output.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        monitor.done();
                                        throw throwable;
                                    }
                                }
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (IOException iOException) {}
                            }
                            monitor.done();
                            break block36;
                        }
                        if (reader == null) break block39;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                }
                WaiversPanel.this.downloadComplete(allowViewing);
                return Status.OK_STATUS;
            }
        };
        return downloader;
    }

    private void downloadComplete(boolean allowViewing) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer msg = new StringBuffer();
                msg.append("The global waivers file, waivers.xml, has been downloaded to\n" + WaiversPanel.this.waiversFile + ".");
                MessageDialog.open((int)2, null, (String)"Download Complete", (String)msg.toString(), (int)0);
                WaiversPanel.this.handleClick(WaiversPanel.LINK_LIST_WAIVERS);
            }
        });
    }

    public boolean handleClick(String location) {
        if (location.startsWith(LINK_LIST_WAIVERS) || location.equals(this.getPrefix())) {
            this.currentPage = LINK_LIST_WAIVERS;
            super.setHtml(this.getHtml());
            this.setChanged();
            this.notifyObservers("");
            return true;
        }
        if (location.startsWith(LINK_WAIVERS_PRODUCT)) {
            this.currentPage = location;
            super.setHtml(this.getHtml());
            this.setChanged();
            this.notifyObservers("");
            return true;
        }
        if (location.startsWith(LINK_WAIVER_DETAILS)) {
            this.currentPage = location;
            super.setHtml(this.getHtml());
            this.setChanged();
            this.notifyObservers("");
            return true;
        }
        return super.handleClick(location);
    }

    public boolean handleActionClick(String location) {
        if (!super.handleActionClick(location)) {
            int len = this.getPrefix().length();
            if (location.length() < len) {
                return false;
            }
            String cmd = location.substring(len);
            if (cmd.startsWith(LINK_WAIVERS)) {
                boolean allowViewing = false;
                if (location.contains(LINK_WAIVERSPECS)) {
                    allowViewing = true;
                }
                Display myDisplay = Display.getDefault();
                Shell myShell = new Shell(myDisplay);
                DirectoryDialog dirDialog = new DirectoryDialog(myShell);
                dirDialog.setText("Global Waivers Download Directory.");
                dirDialog.setMessage("Select the directory to which the global certification waivers file will download.");
                if (!this.waiversFile.isEmpty()) {
                    File downloadLoc = new File(this.waiversFile);
                    dirDialog.setFilterPath(downloadLoc.getParent());
                } else if (VMWBConfig.isWorkbenchIde()) {
                    File downloadLoc = new File(WAIVERS_DEFAULT_DIR);
                    if (!downloadLoc.exists()) {
                        downloadLoc.mkdirs();
                    }
                    dirDialog.setFilterPath(WAIVERS_DEFAULT_DIR);
                }
                String downloadDir = dirDialog.open();
                if (downloadDir != null) {
                    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                    String waiversFile = String.valueOf(downloadDir) + File.separator + WAIVERS_FILE_NAME;
                    store.setValue(WAIVERS_FILE_PATH, waiversFile);
                    this.setWaiversFile(waiversFile);
                    Job downloader = this.getWaiverDownloader(waiversFile, allowViewing);
                    downloader.schedule();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public String getPrefix() {
        return LINK_PREFIX;
    }

    public String getHomeHtml() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public String getHtml() {
        if (this.currentPage != null) {
            if (this.currentPage.startsWith(LINK_LIST_WAIVERS)) {
                File waiverFilePath = new File(this.waiversFile);
                if (waiverFilePath.exists()) {
                    return this.getWaiversHtml();
                }
                StringBuilder sb = new StringBuilder();
                super.addContentHeader(sb, this.getHeader());
                sb.append("<li>There are no available certification waivers at this time.<br>\n");
                sb.append("<a href=\"").append(this.getPrefix()).append(LINK_WAIVERSPECS).append("\">Download</a> the list of Global Waivers from VMware.</li>\n");
                sb.append("</ul>\n");
                return sb.toString();
            }
            if (this.currentPage.startsWith(LINK_WAIVERS_PRODUCT)) {
                int length = LINK_WAIVERS_PRODUCT.length();
                return this.getWaiversByComponentHTML(this.currentPage.substring(length));
            }
            if (this.currentPage.startsWith(LINK_WAIVER_DETAILS)) {
                int length = LINK_WAIVER_DETAILS.length();
                return this.getWaiverDetails(this.currentPage.substring(length));
            }
        }
        return super.getHtml();
    }

    private void getWaiversByComponent() {
        this.retrieveWaivers();
        this.waiversByCompType = new TreeMap<String, List<WaiverData>>();
        String key = null;
        try {
            XMLParser parser = new XMLParser();
            File waiverFilePath = new File(this.waiversFile);
            Document document = parser.parseXml((Object)waiverFilePath);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList compList = (NodeList)xpath.evaluate("//componentType", document, XPathConstants.NODESET);
            int i = 0;
            while (i < compList.getLength()) {
                Node node = compList.item(i);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WaiversByCompType.class});
                Unmarshaller m = context.createUnmarshaller();
                WaiversByCompType wbc = (WaiversByCompType)m.unmarshal(node);
                key = wbc.getCompType();
                if (!this.waiversByCompType.containsKey(key)) {
                    this.waiversByCompType.put(key, wbc.getWaiverList());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrieveWaivers() {
        this.waiverArtifacts = new TreeMap<String, WaiverData>();
        String key = null;
        try {
            XMLParser parser = new XMLParser();
            File waiverFilePath = new File(this.waiversFile);
            Document document = parser.parseXml((Object)waiverFilePath);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList waivers = (NodeList)xpath.evaluate("//waiver", document, XPathConstants.NODESET);
            int i = 0;
            while (i < waivers.getLength()) {
                Node node = waivers.item(i);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WaiverData.class});
                Unmarshaller m = context.createUnmarshaller();
                WaiverData waiverData = (WaiverData)m.unmarshal(node);
                key = waiverData.getId();
                if (!this.waiverArtifacts.containsKey(key)) {
                    this.waiverArtifacts.put(key, waiverData);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getWaiversHtml() {
        StringBuilder page = new StringBuilder();
        this.getWaiversByComponent();
        this.addContentHeader(page, LINK_WAIVERS_PRODUCT_DESCR);
        page.append("<p><a href=\"").append(this.getPrefix()).append(LINK_WAIVERSPECS).append("\">Download</a> the list of current Global Waivers from VMware<br>\n");
        page.append("or select the type of waiver from the following list:<p>&nbsp;");
        Set<String> compKeys = this.waiversByCompType.keySet();
        for (String key : compKeys) {
            String productTypeLink = LINK_WAIVERS_PRODUCT + key;
            page.append("<li><a href=\"" + productTypeLink + "\">" + key + "</a></li>");
        }
        page.append("</ul><br>\n");
        page.append("</div>\n");
        return page.toString();
    }

    private String getWaiversByComponentHTML(String component) {
        String comp = component.replace("%20", " ");
        String waiversTitle = "Waiver Details for " + comp;
        List<WaiverData> waiverDataList = this.waiversByCompType.get(comp);
        StringBuilder page = new StringBuilder();
        int count = waiverDataList.size();
        String header = String.valueOf(waiversTitle) + " <span style='font-size: 70%; color: #c0c0c0;'> " + count + " available</span>";
        this.addContentHeaderWithSearch(page, header);
        Collections.sort(waiverDataList);
        for (WaiverData data : waiverDataList) {
            StringBuilder itemContent = new StringBuilder();
            itemContent.append("<span style='width: 140px;'>");
            String detailLink = LINK_WAIVER_DETAILS + data.getId();
            itemContent.append("<a href=\"" + detailLink + "\">" + data.getId() + "</a>");
            itemContent.append("</span>&nbsp;&nbsp;");
            itemContent.append(data.getShortDesc());
            this.addContentItemForSearch(page, itemContent.toString());
        }
        this.addContentFooterForSearch(page);
        return page.toString();
    }

    private String getWaiverDetails(String id) {
        StringBuilder page = new StringBuilder();
        WaiverData waiverArt = this.waiverArtifacts.get(id);
        page.append("<ul class='panel'>\n");
        page.append("<li class='header'>Waiver Details</li>\n");
        page.append("<table style=\"width: 100%; font-family: Arial, Helvetica, sans-serif;\">");
        page.append("<table>");
        page.append("<tr valign=\"top\"> <td><b>Waiver Id:</b></td><td>&nbsp;&nbsp;</td><td>");
        page.append(waiverArt.getId());
        page.append("</td></tr>");
        page.append("<tr><td>&nbsp;</td></tr>");
        page.append("<tr><td><b>Description:</b></td><td>&nbsp;&nbsp;</td><td>");
        page.append(waiverArt.getShortDesc());
        page.append("</td></tr>");
        page.append("</table><br/></td></tr>");
        String summary = waiverArt.getSummary();
        if (summary != null) {
            page.append("<tr><td>");
            page.append(this.getWaiverSummary(summary));
            page.append("<br/></td></tr>");
            page.append("<tr><td>&nbsp;</td></tr>");
        }
        page.append("<tr><td>");
        page.append(this.getWaivedTestsTable(waiverArt));
        page.append("<br/></td></tr>");
        page.append("<tr><td>&nbsp;</td></tr>");
        page.append("<tr><td>");
        page.append(this.getWaivedReleasesTable(waiverArt));
        page.append("</td></tr>");
        page.append("</table>");
        page.append("</ul>\n");
        return page.toString();
    }

    private String getWaiverSummary(String summary) {
        StringBuffer table = new StringBuffer();
        table.append("<table id='waiverSummary'><b>Waiver Summary</b>\n");
        table.append("<thead><tr>");
        table.append("<th class=\"art-waiver\">Summary</th>");
        table.append("</tr></thead>\n");
        table.append("<td class=\"art-waiver\">");
        String temp = summary.replace("\n", "<br>");
        table.append(temp);
        table.append("</td></tr>");
        table.append("</table>");
        return table.toString();
    }

    private String getWaivedTestsTable(WaiverData waiver) {
        StringBuffer table = new StringBuffer();
        table.append("<table id='waiverDetails'><b>Waived Tests</b>\n");
        table.append("<thead><tr>");
        table.append("<th class=\"art-title\">Name</th>");
        table.append("<th class=\"art-title\">Category</th>");
        table.append("<th class=\"art-title\">Session Type</th>");
        table.append("</tr></thead>\n");
        List<Object> testList = new ArrayList();
        testList = waiver.getWaivedTests();
        for (TestData testData : testList) {
            table.append("<tr class=\"art-row\" valign=\"top\">");
            table.append("<td class=\"art-item\">");
            table.append(testData.getName());
            table.append("</td><td class=\"art-item\">");
            table.append(testData.getCategory());
            table.append("</td><td class=\"art-item\">");
            table.append(testData.getSessionType());
            table.append("</td></tr>");
        }
        table.append("</table>");
        return table.toString();
    }

    private String getWaivedReleasesTable(WaiverData waiver) {
        StringBuffer table = new StringBuffer();
        table.append("<table id='waiverDetails'><b>Waived Releases</b>\n");
        table.append("<thead><tr>");
        table.append("<th class=\"art-title\">Description</th>");
        table.append("<th class=\"art-title\">Version</th>");
        table.append("<th class=\"art-title\">Type</th>");
        table.append("<th class=\"art-title\">Update</th>");
        table.append("</tr></thead>\n");
        List<Object> releaseList = new ArrayList();
        releaseList = waiver.getWaivedReleases();
        for (ReleaseData releaseData : releaseList) {
            table.append("<tr class=\"art-row\" valign=\"top\">");
            table.append("<td class=\"art-item\">");
            table.append(releaseData.getDescription());
            table.append("</td><td class=\"art-item\">");
            table.append(releaseData.getVersion());
            table.append("</td><td class=\"art-item\">");
            table.append(releaseData.getType());
            table.append("</td><td class=\"art-item\">");
            table.append(releaseData.getUpdate());
            table.append("</td></tr>");
        }
        table.append("</table>");
        return table.toString();
    }
}

