/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import com.vmware.vide.p2action.P2ActionPlugin;
import com.vmware.vide.p2action.UntarAction;
import com.vmware.vide.p2action.vIDEInstallHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class CleanupUntarAction
extends ProvisioningAction {
    private static ILog logger = P2ActionPlugin.getInstance().getLog();

    public IStatus execute(Map<String, Object> parameters) {
        return CleanupUntarAction.cleanupUntar(parameters, true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return UntarAction.untar(parameters, false);
    }

    public static IStatus cleanupUntar(Map<String, Object> parameters, boolean restoreable) {
        String[] untaredFiles;
        String untaredFilesKey = UntarAction.getUntaredFilesKey(parameters);
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        String files = profile.getInstallableUnitProperty(iu, untaredFilesKey);
        if (files == null || files.isEmpty()) {
            return Status.OK_STATUS;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        ArrayList<String> dirs = new ArrayList<String>();
        String[] stringArray = untaredFiles = files.split(Pattern.quote("|"));
        int n = untaredFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (!file.isEmpty()) {
                File f;
                if (CleanupUntarAction.isSymlinkFile(file)) {
                    f = new File(file.substring(1));
                    if (store != null) {
                        try {
                            store.backup(f);
                        }
                        catch (IOException e) {
                            logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", null, (Throwable)e));
                        }
                    }
                    f.delete();
                } else {
                    f = new File(file);
                    if (f.exists()) {
                        if (f.isDirectory()) {
                            String[] l = f.list();
                            if (l != null) {
                                if (l.length == 0) {
                                    if (store != null) {
                                        try {
                                            store.backup(f);
                                        }
                                        catch (IOException e) {
                                            logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", null, (Throwable)e));
                                        }
                                    }
                                    f.delete();
                                } else {
                                    dirs.add(file);
                                }
                            }
                        } else {
                            if (store != null) {
                                try {
                                    store.backup(f);
                                }
                                catch (IOException e) {
                                    logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", null, (Throwable)e));
                                }
                            }
                            f.delete();
                        }
                    }
                }
            }
            ++n2;
        }
        Collections.sort(dirs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int depth1 = this.getDepth(o1);
                int depth2 = this.getDepth(o2);
                return depth2 - depth1;
            }

            int getDepth(String s) {
                int count = 0;
                int i = 0;
                while (i < s.length()) {
                    if (s.charAt(i) == '/' || s.charAt(i) == '\\') {
                        ++count;
                    }
                    ++i;
                }
                return count;
            }
        });
        for (String dir : dirs) {
            File d = new File(dir);
            String[] l = d.list();
            if (l == null || l.length != 0) continue;
            if (store != null) {
                try {
                    store.backup(d);
                }
                catch (IOException e) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", null, (Throwable)e));
                }
            }
            d.delete();
        }
        vIDEInstallHelper.cleanupTargetLocation(parameters);
        return Status.OK_STATUS;
    }

    private static boolean isSymlinkFile(String file) {
        return file.charAt(0) == '*';
    }
}

