/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class LocationDialog
extends Dialog {
    private final String packageName;
    private Text dirText;
    private String resultDir;
    private final String defaultDir;

    protected LocationDialog(Shell parentShell, String name, String defaultDir) {
        super(parentShell);
        this.packageName = name;
        this.defaultDir = defaultDir;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Installation for " + this.packageName);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(6, true));
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        group.setText("Choose a directory to install the package");
        Label label = new Label((Composite)group, 0);
        label.setText("Directory : ");
        this.dirText = new Text((Composite)group, 2048);
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 4;
        this.dirText.setLayoutData((Object)data);
        if (this.defaultDir != null) {
            this.dirText.setText(this.defaultDir);
        }
        Button button = new Button((Composite)group, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(LocationDialog.this.getShell());
                String installDir = dialog.open();
                if (installDir != null) {
                    LocationDialog.this.dirText.setText(installDir);
                }
            }
        });
        return composite;
    }

    public void okPressed() {
        String dir = this.dirText.getText().trim();
        if (dir == null || dir.isEmpty()) {
            return;
        }
        File install = new File(dir);
        String errorMessage = null;
        if (!install.exists()) {
            errorMessage = "The directory does not exist";
        } else if (!install.isDirectory()) {
            errorMessage = String.valueOf(install.getName()) + " is not a directory.";
        } else if (!install.canWrite()) {
            errorMessage = "No write permission to " + install.getName();
        }
        if (errorMessage != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)errorMessage);
            return;
        }
        this.resultDir = dir;
        super.okPressed();
    }

    public String getResultDir() {
        return this.resultDir;
    }
}

