/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressReaderThread
extends Thread {
    private static final String PERCENT_HEADER = "%% ";
    private static final int PERCENT_HEADER_LEN = "%% ".length();
    private final InputStream stdoutInputStream;
    private final IProgressMonitor monitor;

    public ProgressReaderThread(Process process, IProgressMonitor monitor) {
        this.stdoutInputStream = process.getInputStream();
        this.monitor = monitor;
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.stdoutInputStream));
        String line = null;
        int counter = 0;
        int totalWorked = 0;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(PERCENT_HEADER)) {
                    if (counter % 10 == 0) {
                        try {
                            int percent = (int)Double.parseDouble(line.substring(PERCENT_HEADER_LEN));
                            int diff = percent - totalWorked;
                            if (diff > 0) {
                                totalWorked += diff;
                                this.monitor.worked(diff);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    System.out.println(line);
                }
                ++counter;
            }
        }
        catch (IOException iOException) {}
    }
}

