/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import com.vmware.vide.p2action.LocationDialog;
import com.vmware.vide.p2action.P2ActionPlugin;
import com.vmware.vide.p2action.ReadStreamToStringThread;
import com.vmware.vide.p2action.rpm.RPMUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class vIDEInstallHelper {
    private static final Logger logger = LoggerFactory.getLogger(vIDEInstallHelper.class);
    private static final String OP_GETENV = "(@env ";
    public static final String PROP_NAME = "propName";
    public static final String PROP_VALUE = "propValue";
    public static final String PROP_PREV_VALUE = "previousValue";
    public static final String CANCELED_BY_USER = "Canceled by the user";
    private static final String TARGET_LOCATION = "targetLocation";
    private static final String DROPINS = "dropins";
    private static final String FEATURES = "features";
    private static final String PLUGINS = "plugins";
    private static final String RPM_DIR = "rpm";

    private static void logError(String msg, Exception e) {
        try {
            logger.error(msg, (Throwable)e);
            P2ActionPlugin plugin = P2ActionPlugin.getInstance();
            plugin.getLog().log((IStatus)new Status(4, "com.vmware.vide.p2action", 0, msg, (Throwable)e));
        }
        catch (Exception exception) {}
    }

    public static String getInstallFolder(Map<String, Object> parameters) {
        return (String)parameters.get("installFolder");
    }

    public static String getInstallDir(Map<String, Object> parameters) {
        String resolvedDropinsDir;
        String pluginOrFeatureDir;
        String dropinsDir;
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        if (iu == null) {
            return null;
        }
        String installFolder = vIDEInstallHelper.getInstallFolder(parameters);
        if (installFolder == null) {
            vIDEInstallHelper.logError("installFolder is null", null);
            return null;
        }
        String id = iu.getId();
        Version version = iu.getVersion();
        StringBuffer nameBuffer = new StringBuffer();
        int featureNameIndex = id.indexOf(".feature.group");
        if (featureNameIndex != -1) {
            dropinsDir = "/dropins/eclipse/features/";
            pluginOrFeatureDir = "/features/";
            nameBuffer.append(id.substring(0, featureNameIndex));
        } else {
            dropinsDir = "/dropins/eclipse/plugins/";
            pluginOrFeatureDir = "/plugins/";
            nameBuffer.append(id);
        }
        nameBuffer.append("_");
        nameBuffer.append(version);
        String name = nameBuffer.toString();
        StringBuffer install = new StringBuffer(installFolder);
        install.append(dropinsDir);
        install.append(name);
        String resolvedInstallDir = resolvedDropinsDir = install.toString();
        if (!new File(resolvedInstallDir).exists()) {
            install = new StringBuffer(installFolder);
            install.append(pluginOrFeatureDir);
            install.append(name);
            resolvedInstallDir = install.toString();
        }
        if (!new File(resolvedInstallDir).exists()) {
            Profile profile = (Profile)parameters.get("profile");
            String cacheDir = profile.getLocalProperty("org.eclipse.equinox.p2.cache");
            install = new StringBuffer(cacheDir);
            install.append(pluginOrFeatureDir);
            install.append(name);
            resolvedInstallDir = install.toString();
        }
        if (!new File(resolvedInstallDir).exists()) {
            vIDEInstallHelper.logError("ERROR unable to resolve install directory for id='" + id + "' version='" + version.toString() + "' installFolder='" + installFolder + "' Tried '" + resolvedDropinsDir + "' AND '" + resolvedInstallDir + "'", null);
            return null;
        }
        return resolvedInstallDir;
    }

    private static boolean isValidRpmFile(File rpmDir, String rpmFile) {
        java.nio.file.Path rpmPath = Paths.get(rpmDir.toString(), rpmFile);
        try {
            return RPMUtil.isRPM(rpmPath);
        }
        catch (IOException e) {
            logger.error("An error occurred during detecting a rpm file.", (Throwable)e);
            return false;
        }
    }

    public static boolean isInstalled(File rpmDir, String rpmFile) {
        String rpmName;
        block3: {
            try {
                rpmName = vIDEInstallHelper.getRpmName(rpmDir, rpmFile);
                if (rpmName != null) break block3;
                logger.error("Failed to get rpm name for {}/{}", (Object)rpmDir, (Object)rpmFile);
                return false;
            }
            catch (Exception e) {
                logger.error("Exception trying to run rpm to figure out if '" + rpmFile + "' is installed.", (Throwable)e);
                return false;
            }
        }
        return RPMUtil.isRPMInstalled(rpmName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRpmStillRequired(File rpmDir, String rpmFile) {
        try {
            String rpmName = vIDEInstallHelper.getRpmName(rpmDir, rpmFile, false, false);
            if (rpmName == null) {
                logger.error("Failed to get rpm name for {}/{}", (Object)rpmDir, (Object)rpmFile);
                return false;
            }
            Process proc = new ProcessBuilder(RPM_DIR, "-q", "--whatrequires", rpmName).start();
            ReadStreamToStringThread stderrReaderThread = new ReadStreamToStringThread("RPM err reader", proc.getErrorStream());
            ReadStreamToStringThread stdoutReaderThread = new ReadStreamToStringThread("RPM out reader", proc.getInputStream());
            stderrReaderThread.start();
            stdoutReaderThread.start();
            proc.waitFor();
            stdoutReaderThread.join();
            stderrReaderThread.join();
            if (proc.exitValue() == 0) {
                return true;
            }
            if (proc.exitValue() == 1) {
                if (stdoutReaderThread.getAllOutput().indexOf("no package requires") != -1) return false;
            }
            logger.error("'rpm -q --whatrequires {}' exited with {}.  RPM cmd stderr='{}'", new Object[]{rpmName, new Integer(proc.exitValue()), stderrReaderThread.getAllOutput()});
            return false;
        }
        catch (Exception e) {
            logger.error("Exception trying to run rpm to figure out if '" + rpmFile + "' is required.", (Throwable)e);
        }
        return false;
    }

    public static String getRpmName(File rpmDir, String rpmFile, boolean includeVersion, boolean includeRelease) {
        String rpmName = null;
        java.nio.file.Path rpmPath = Paths.get(rpmDir.toString(), rpmFile);
        try {
            rpmName = RPMUtil.getRPMName(rpmPath, includeVersion, includeRelease);
        }
        catch (Exception e) {
            logger.error("Exception trying to get rpm name for " + rpmPath.toString(), (Throwable)e);
        }
        return rpmName;
    }

    public static String getRpmName(File rpmDir, String rpmFile) {
        return vIDEInstallHelper.getRpmName(rpmDir, rpmFile, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> readFeatureRpmManifest(File rpmManifest) {
        ArrayList<String> rpmList = new ArrayList<String>(20);
        BufferedReader in = null;
        try {
            try {
                String str;
                in = new BufferedReader(new FileReader(rpmManifest));
                while ((str = in.readLine()) != null) {
                    if ((str = str.trim()).startsWith("#")) continue;
                    rpmList.add(str);
                }
                return rpmList;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (in == null) return rpmList;
                try {
                    in.close();
                    return rpmList;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return rpmList;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (in == null) return rpmList;
                try {
                    in.close();
                    return rpmList;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return rpmList;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List<String> getRPMList(File rpmDir, boolean install) {
        ArrayList<String> filteredRpms = new ArrayList<String>();
        if (rpmDir.exists() && rpmDir.isDirectory()) {
            List<String> rpms;
            java.nio.file.Path rpmManifestPath = RPMUtil.getRPMManifest(rpmDir.toPath());
            if (rpmManifestPath != null) {
                logger.info("Reading rpm install list from " + rpmManifestPath.toString());
                rpms = vIDEInstallHelper.readFeatureRpmManifest(rpmManifestPath.toFile());
            } else {
                rpms = Arrays.asList(rpmDir.list());
            }
            for (String rpm : rpms) {
                if (!vIDEInstallHelper.isValidRpmFile(rpmDir, rpm)) continue;
                boolean isRpmInstalled = vIDEInstallHelper.isInstalled(rpmDir, rpm);
                if ((!install || isRpmInstalled) && (install || !isRpmInstalled)) continue;
                filteredRpms.add(rpm);
            }
        }
        return filteredRpms;
    }

    public static Map<String, Object> replaceSourcePath(Map<String, Object> parameters) {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        newParams.putAll(parameters);
        if (!newParams.containsKey("source")) {
            return newParams;
        }
        Path path = new Path((String)newParams.get("source"));
        if (path.isAbsolute()) {
            return newParams;
        }
        String install = vIDEInstallHelper.getInstallDir(newParams);
        if (install != null) {
            StringBuffer newSource = new StringBuffer(install);
            newSource.append('/');
            newSource.append(path.toOSString());
            newParams.put("source", newSource.toString());
        }
        return newParams;
    }

    public static String findFilePathPattern(String searchDir, final String namePart) throws IOException {
        File[] files = null;
        if (namePart.contains("*")) {
            String regexp = vIDEInstallHelper.translateAsteriscToRegularExpression(namePart);
            final Pattern pattern = Pattern.compile(regexp);
            File dir = new File(searchDir);
            files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    Matcher m = pattern.matcher(path.getName());
                    return m.matches();
                }
            });
        } else {
            File dir = new File(searchDir);
            files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.getName().contains(namePart);
                }
            });
        }
        if (files != null && files.length > 0) {
            return files[0].getCanonicalPath();
        }
        throw new IOException("Unable to find matching file '" + namePart + "' in " + searchDir);
    }

    private static String translateAsteriscToRegularExpression(String s) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int index = 0;
        while (index < s.length()) {
            if (s.charAt(index) == '*') {
                sb.append(Pattern.quote(s.substring(start, index)));
                sb.append(".*");
                start = index + 1;
            }
            ++index;
        }
        return sb.toString();
    }

    public static void updateTargetParam(Map<String, Object> newParams) {
        String target = (String)newParams.get("target");
        if (target != null) {
            newParams.put("target", vIDEInstallHelper.translateEnv(target));
        }
    }

    public static String resolveSourcePath(Map<String, Object> params, String subDir) throws IOException {
        String install = vIDEInstallHelper.getInstallDir(params);
        String namePart = (String)params.get("source");
        return vIDEInstallHelper.findFilePathPattern(String.valueOf(install) + subDir, namePart);
    }

    public static String resolveTargetPath(final Map<String, Object> params, final String packageName) {
        String target = (String)params.get("target");
        if (target == null) {
            IInstallableUnit iu = (IInstallableUnit)params.get("iu");
            Profile profile = (Profile)params.get("profile");
            final String previousLocation = profile.getInstallableUnitProperty(iu, TARGET_LOCATION);
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LocationDialog dialog = new LocationDialog(display.getActiveShell(), packageName, previousLocation);
                    if (dialog.open() == 0) {
                        params.put("target", dialog.getResultDir());
                    }
                }
            });
            target = (String)params.get("target");
            if (target == null || target.isEmpty()) {
                throw new RuntimeException(CANCELED_BY_USER);
            }
            profile.setInstallableUnitProperty(iu, TARGET_LOCATION, target);
        } else {
            target = vIDEInstallHelper.translateEnv(target);
            params.put("target", target);
        }
        return target;
    }

    public static void propagateTargetLocation(Map<String, Object> params) throws Exception {
        String name = (String)params.get(PROP_NAME);
        if (name != null) {
            Manipulator manipulator = (Manipulator)params.get("manipulator");
            manipulator.getConfigData().setProperty(name, (String)params.get("target"));
        }
    }

    public static void cleanupTargetLocation(Map<String, Object> params) {
        Manipulator manipulator;
        String name = (String)params.get(PROP_NAME);
        if (name != null && (manipulator = (Manipulator)params.get("manipulator")) != null) {
            manipulator.getConfigData().setProperty(name, null);
        }
        IInstallableUnit iu = (IInstallableUnit)params.get("iu");
        Profile profile = (Profile)params.get("profile");
        profile.setInstallableUnitProperty(iu, TARGET_LOCATION, null);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean checkLinkSupported() {
        if (vIDEInstallHelper.isWindows()) {
            ProcessBuilder pb = new ProcessBuilder("cmd", "/c", "help", "|", "find", "\"MKLINK\"");
            try {
                Process proc = pb.start();
                InputStreamThread it = new InputStreamThread("StdOut reader", proc.getInputStream());
                InputStreamThread et = new InputStreamThread("StdErr reader", proc.getErrorStream());
                it.start();
                et.start();
                proc.waitFor();
                it.join();
                et.join();
                return proc.exitValue() == 0;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public static void mklink(File out, String fileName, String linkName, boolean symlink) throws IOException, InterruptedException {
        ProcessBuilder pb = null;
        if (vIDEInstallHelper.isWindows()) {
            File linkFile = new File(linkName);
            if (!linkFile.isAbsolute()) {
                linkFile = new File(new File(out, fileName).getParentFile(), linkName);
            }
            pb = linkFile.isDirectory() ? new ProcessBuilder("cmd", "/c", "mklink", "/d", fileName, linkName) : (symlink ? new ProcessBuilder("cmd", "/c", "mklink", fileName, linkName) : new ProcessBuilder("cmd", "/c", "mklink", "/h", fileName, linkName));
        } else {
            pb = symlink ? new ProcessBuilder("ln", "-s", linkName, fileName) : new ProcessBuilder("ln", linkName, fileName);
        }
        pb.directory(out);
        Process proc = pb.start();
        InputStreamThread it = new InputStreamThread("Mklink stdOut reader", proc.getInputStream());
        InputStreamThread et = new InputStreamThread("Mklink stdErr reader", proc.getErrorStream());
        it.start();
        et.start();
        proc.waitFor();
        it.join();
        et.join();
    }

    public static String translateEnv(String str) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < str.length()) {
            if (str.startsWith(OP_GETENV, index)) {
                int rollback = index;
                index += OP_GETENV.length();
                int vstart = index = vIDEInstallHelper.skipSpaces(str, index);
                int vend = index = vIDEInstallHelper.getVariable(str, index);
                char c = str.charAt(index);
                if (!Character.isWhitespace(c) && c != ')') {
                    System.err.println(String.format("Bad char[%c] in variable name in the string [%s]", Character.valueOf(c), str));
                    sb.append(str.substring(rollback, index));
                    ++index;
                    continue;
                }
                String var = str.substring(vstart, vend);
                c = str.charAt(index = vIDEInstallHelper.skipSpaces(str, index));
                if (c == ')') {
                    String val = System.getenv(var);
                    if (val == null) {
                        System.err.println(String.format("Environment variable [%s] is not defined", var));
                        sb.append(str.substring(rollback, index + 1));
                    } else {
                        sb.append(val);
                    }
                    ++index;
                    continue;
                }
                StringBuilder valstr = new StringBuilder();
                if (c == '\'' || c == '\"') {
                    index = vIDEInstallHelper.getQuotedValue(str, index, valstr);
                } else {
                    vstart = index;
                    vend = index = vIDEInstallHelper.getValue(str, index);
                    valstr.append(str.substring(vstart, vend));
                }
                index = vIDEInstallHelper.skipSpaces(str, index);
                if (index < str.length() && str.charAt(index) == ')') {
                    ++index;
                } else {
                    System.err.println(String.format("Missing closing parents [%s]", str));
                }
                String val = System.getenv(var);
                if (val == null) {
                    val = valstr.toString();
                }
                sb.append(val);
                continue;
            }
            sb.append(str.charAt(index));
            ++index;
        }
        return sb.toString();
    }

    private static int skipSpaces(String str, int index) {
        while (index < str.length()) {
            if (!Character.isWhitespace(str.charAt(index))) break;
            ++index;
        }
        return index;
    }

    private static int getVariable(String str, int index) {
        while (index < str.length()) {
            char c = str.charAt(index);
            if (!Character.isLetterOrDigit(c) && c != '_') break;
            ++index;
        }
        return index;
    }

    private static int getValue(String str, int index) {
        while (index < str.length()) {
            char c = str.charAt(index);
            if (Character.isWhitespace(c) || c == ')') break;
            ++index;
        }
        return index;
    }

    public static int getQuotedValue(String str, int index, StringBuilder out) {
        char searchFor = str.charAt(index);
        boolean found = false;
        ++index;
        while (index < str.length()) {
            if (str.substring(index).startsWith("\\" + searchFor)) {
                out.append(str.charAt(index + 1));
                index += 2;
                continue;
            }
            if (str.charAt(index) == searchFor) {
                ++index;
                found = true;
                break;
            }
            out.append(str.charAt(index));
            ++index;
        }
        if (!found) {
            System.err.println("Unmatched " + searchFor + ".");
        }
        return index;
    }

    public static IInstallableUnit getInstallableUnit(Map<String, Object> parameters) {
        Object o = parameters.get("iu");
        if (o instanceof IInstallableUnit) {
            return (IInstallableUnit)o;
        }
        return null;
    }

    public static ProvisioningContext getProvisioningContext(Map<String, Object> parameters) {
        Object o = parameters.get("context");
        if (o instanceof ProvisioningContext) {
            return (ProvisioningContext)o;
        }
        return null;
    }

    public static List<IArtifactRepository> getArtifactRepositories(ProvisioningContext context) {
        final ArrayList<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
        IQueryable queryArtifactRepositories = context.getArtifactRepositories((IProgressMonitor)new NullProgressMonitor());
        queryArtifactRepositories.query((IQuery)new IQuery<IArtifactRepository>(){

            public IQueryResult<IArtifactRepository> perform(Iterator<IArtifactRepository> iterator) {
                while (iterator.hasNext()) {
                    artifactRepositories.add(iterator.next());
                }
                return null;
            }

            public IExpression getExpression() {
                return null;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return artifactRepositories;
    }

    private static String normalizeId(String id) {
        int index = -1;
        index = id.indexOf(".feature.group");
        if (index != -1) {
            return id.substring(0, index);
        }
        index = id.indexOf(".feature.jar");
        if (index != -1) {
            return id.substring(0, index);
        }
        return id;
    }

    private static boolean artifactKeyEquivalent(IArtifactKey key, String iuid, Version version) {
        String id = vIDEInstallHelper.normalizeId(iuid);
        return key.getId().equals(id) && version.equals(key.getVersion());
    }

    public static List<IArtifactRepository> findArtifactRepositoriesByIUID(String iuid, Version version, List<IArtifactRepository> repositories) {
        ArrayList<IArtifactRepository> foundRepositories = new ArrayList<IArtifactRepository>();
        for (IArtifactRepository repository : repositories) {
            if (!(repository instanceof SimpleArtifactRepository)) continue;
            SimpleArtifactRepository repo = (SimpleArtifactRepository)repository;
            Set descriptors = repo.getDescriptors();
            boolean found = false;
            for (SimpleArtifactDescriptor desc : descriptors) {
                IArtifactKey key = desc.getArtifactKey();
                if (!vIDEInstallHelper.artifactKeyEquivalent(key, iuid, version)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            foundRepositories.add((IArtifactRepository)repo);
        }
        return foundRepositories;
    }

    private static List<java.nio.file.Path> searchRPMDirectoriesByArtifactKey(java.nio.file.Path eclipseDir, IArtifactKey key) {
        java.nio.file.Path rpmDirPath;
        ArrayList<java.nio.file.Path> rpmDirectories = new ArrayList<java.nio.file.Path>();
        String name = key.getId() + '_' + key.getVersion().toString();
        File dropinsDir = Paths.get(eclipseDir.toString(), DROPINS).toFile();
        if (dropinsDir.isDirectory()) {
            File[] fileArray = dropinsDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    String dir = f.toPath().toString();
                    String dirName = f.toPath().getFileName().toString();
                    if (dirName.equals(PLUGINS) || dirName.equals(FEATURES)) {
                        rpmDirPath = Paths.get(dir, name, RPM_DIR);
                        if (rpmDirPath.toFile().isDirectory()) {
                            rpmDirectories.add(rpmDirPath);
                        }
                    } else {
                        rpmDirPath = Paths.get(dir, PLUGINS, name, RPM_DIR);
                        if (rpmDirPath.toFile().isDirectory()) {
                            rpmDirectories.add(rpmDirPath);
                        }
                        if ((rpmDirPath = Paths.get(dir, FEATURES, name, RPM_DIR)).toFile().isDirectory()) {
                            rpmDirectories.add(rpmDirPath);
                        }
                    }
                }
                ++n2;
            }
        }
        if ((rpmDirPath = Paths.get(eclipseDir.toString(), PLUGINS, name, RPM_DIR)).toFile().isDirectory()) {
            rpmDirectories.add(rpmDirPath);
        }
        if ((rpmDirPath = Paths.get(eclipseDir.toString(), FEATURES, name, RPM_DIR)).toFile().isDirectory()) {
            rpmDirectories.add(rpmDirPath);
        }
        return rpmDirectories;
    }

    public static LinkedHashSet<java.nio.file.Path> getRPMDirectoriesInArtifactRepositories(java.nio.file.Path eclipseDir, java.nio.file.Path iuRpmDir, List<IArtifactRepository> repositories) {
        LinkedHashSet<java.nio.file.Path> rpmDirectories = new LinkedHashSet<java.nio.file.Path>();
        rpmDirectories.add(iuRpmDir);
        for (IArtifactRepository repo : repositories) {
            if (!(repo instanceof SimpleArtifactRepository)) continue;
            for (SimpleArtifactDescriptor desc : ((SimpleArtifactRepository)repo).getDescriptors()) {
                rpmDirectories.addAll(vIDEInstallHelper.searchRPMDirectoriesByArtifactKey(eclipseDir, desc.getArtifactKey()));
            }
        }
        return rpmDirectories;
    }

    static class InputStreamThread
    extends Thread {
        InputStream is;

        InputStreamThread(String name, InputStream is) {
            super(name);
            this.is = is;
        }

        @Override
        public void run() {
            try {
                try {
                    while (this.is.read() >= 0) {
                    }
                }
                catch (IOException e) {
                    vIDEInstallHelper.logError(this.getName(), e);
                    try {
                        this.is.close();
                    }
                    catch (IOException e2) {
                        vIDEInstallHelper.logError(this.getName(), e2);
                    }
                }
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    vIDEInstallHelper.logError(this.getName(), e);
                }
            }
        }
    }
}

