/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleDevice {
    private Console console;
    private BufferedReader reader;

    public ConsoleDevice() {
        if (System.console() != null) {
            this.console = System.console();
            this.reader = null;
        } else {
            this.console = null;
            this.reader = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public String readLine() throws IOException {
        String line = null;
        line = this.console != null ? this.console.readLine() : this.reader.readLine();
        return line;
    }

    public String readPassword() throws IOException {
        String password = null;
        if (this.console != null) {
            char[] value = this.console.readPassword();
            if (value != null) {
                password = new String(value);
            }
        } else {
            password = this.reader.readLine();
        }
        return password;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

