/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils;

import com.vmware.vide.utils.net.HttpLogger;
import java.io.File;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class VIDEUtilPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.vmware.vide.utils";
    private static VIDEUtilPlugin plugin;
    private ServiceTracker tracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tracker = new ServiceTracker(context, IProxyService.class.getName(), null);
        this.tracker.open();
        try {
            File oldStateFile = HttpLogger.getSavedStateFile();
            if (oldStateFile.canRead()) {
                HttpLogger.loadBeacons(oldStateFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            File oldStateFile = HttpLogger.getSavedStateFile();
            if (oldStateFile.exists()) {
                oldStateFile.delete();
            }
            HttpLogger.saveBeacons(oldStateFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tracker.close();
        plugin = null;
        super.stop(context);
    }

    public static VIDEUtilPlugin getDefault() {
        return plugin;
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }
}

