/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestHelper {
    public static String getHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                builder.append("0");
            }
            builder.append(hex);
            ++n2;
        }
        return builder.toString();
    }

    private static String getChecksum(MessageDigest digest, String data) {
        byte[] bytes = digest.digest(data.getBytes());
        return DigestHelper.getHex(bytes);
    }

    private static String getChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fileStream = null;
        BufferedInputStream bufferedStream = null;
        try (FilterInputStream digestStream = null;){
            fileStream = new FileInputStream(file);
            bufferedStream = new BufferedInputStream(fileStream);
            digestStream = new DigestInputStream(bufferedStream, digest);
            while (((DigestInputStream)digestStream).read() != -1) {
            }
            byte[] bytes = digest.digest();
            String string = DigestHelper.getHex(bytes);
            return string;
        }
    }

    public static String getMd5(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        return DigestHelper.getChecksum(digest, data);
    }

    public static String getMd5(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        return DigestHelper.getChecksum(digest, file);
    }

    public static String getSha256(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return DigestHelper.getChecksum(digest, data);
    }

    public static String getSha256(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return DigestHelper.getChecksum(digest, file);
    }
}

