/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.json;

import com.vmware.vide.utils.json.ParserException;
import com.vmware.vide.utils.json.Scanner;
import com.vmware.vide.utils.json.Token;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class Json {
    private static final String ERR_EOL_BEFORE_DATA = "Got a EOL before starting data.";
    private static final String ERR_UNEXPECTED_TOKEN_IN = "Unexpected token [%s] in the [%s].";
    private static final String ERR_MISSING_NAME_SEP = "Missing name separator after [%s] in JSON object";
    private static final String ERR_EXTRA_SEP_IN_OBJ = "Extra value separator after the value of the name [%s] in the JSON object before closing right curly bracket.";
    private static final String ERR_EXTRA_SEP_IN_ARRAY = "Extra value separator in the JSON array before closing right square bracket.";

    public static Object parse(InputStream is) throws IOException, ParserException {
        Token t;
        if (!is.markSupported()) {
            throw new IOException("Mark operation is not supported on the specified input stream.");
        }
        JSONEncode encode = Json.detectEncode(is);
        if (!Charset.isSupported(encode.getCharsetName())) {
            throw new IOException("Unsupported charset [" + encode.getCharsetName() + "] on the specified input stream.");
        }
        Scanner scanner = new Scanner(is, encode.getCharsetName());
        Object object = null;
        while ((t = scanner.getNextToken()) != Token.EOS) {
            if (t == Token.WHITE_SPACE) continue;
            if (t == Token.BEGIN_OBJECT) {
                return Json.getObject(scanner);
            }
            if (t != Token.BEGIN_ARRAY) continue;
            return Json.getArray(scanner);
        }
        return object;
    }

    private static Object getObject(Scanner scanner) throws ParserException, IOException {
        Token t;
        block15: {
            HashMap<String, Object> object = new HashMap<String, Object>();
            boolean nextMember = false;
            String name = null;
            while (true) {
                if ((t = scanner.getNextToken()) == Token.WHITE_SPACE) {
                    continue;
                }
                if (t == Token.END_OBJECT) {
                    if (nextMember) {
                        throw new ParserException(String.format(ERR_EXTRA_SEP_IN_OBJ, name));
                    }
                    return object;
                }
                if (t != Token.STRING) break block15;
                name = (String)Token.STRING.getValue();
                while ((t = scanner.getNextToken()) == Token.WHITE_SPACE) {
                }
                if (t != Token.NAME_SEPARATOR) {
                    throw new ParserException(String.format(ERR_MISSING_NAME_SEP, name));
                }
                while ((t = scanner.getNextToken()) == Token.WHITE_SPACE) {
                }
                if (t.isValue()) {
                    object.put(name, t.getValue());
                } else if (t == Token.BEGIN_OBJECT) {
                    object.put(name, Json.getObject(scanner));
                } else if (t == Token.BEGIN_ARRAY) {
                    object.put(name, Json.getArray(scanner));
                } else {
                    String msg = String.format("Bad token [%s] as value of the name [%s] in the JSON object.", t.getName(), name);
                    throw new ParserException(msg);
                }
                while ((t = scanner.getNextToken()) == Token.WHITE_SPACE) {
                }
                if (t != Token.VALUE_SEPARATOR) break;
                nextMember = true;
            }
            if (t == Token.END_OBJECT) {
                return object;
            }
            String msg = String.format("Bad token [%s] after the value of the name [%s] in the JSON object.", t.getName(), name);
            throw new ParserException(msg);
        }
        throw new ParserException(String.format(ERR_UNEXPECTED_TOKEN_IN, t.getName(), "JSON object"));
    }

    private static Object getArray(Scanner scanner) throws ParserException, IOException {
        Token t;
        ArrayList<Object> array = new ArrayList<Object>();
        boolean nextValue = false;
        while (true) {
            if ((t = scanner.getNextToken()) == Token.WHITE_SPACE) {
                continue;
            }
            if (t == Token.END_ARRAY) {
                if (nextValue) {
                    throw new ParserException(ERR_EXTRA_SEP_IN_ARRAY);
                }
                return array;
            }
            if (t.isValue()) {
                array.add(t.getValue());
            } else if (t == Token.BEGIN_OBJECT) {
                array.add(Json.getObject(scanner));
            } else if (t == Token.BEGIN_ARRAY) {
                array.add(Json.getArray(scanner));
            }
            while ((t = scanner.getNextToken()) == Token.WHITE_SPACE) {
            }
            if (t != Token.VALUE_SEPARATOR) break;
            nextValue = true;
        }
        if (t == Token.END_ARRAY) {
            return array;
        }
        throw new ParserException(String.format(ERR_UNEXPECTED_TOKEN_IN, t.getName(), "JSON array"));
    }

    private static JSONEncode detectEncode(InputStream is) throws IOException {
        is.mark(3);
        try {
            int b0 = is.read();
            if (b0 == -1) {
                throw new IOException(ERR_EOL_BEFORE_DATA);
            }
            if (b0 == 0) {
                int b1 = is.read();
                if (b1 == -1) {
                    throw new IOException(ERR_EOL_BEFORE_DATA);
                }
                if (b1 == 0) {
                    JSONEncode jSONEncode = JSONEncode.UTF32BE;
                    return jSONEncode;
                }
                JSONEncode jSONEncode = JSONEncode.UTF16BE;
                return jSONEncode;
            }
            int b1 = is.read();
            if (b1 == -1) {
                throw new IOException(ERR_EOL_BEFORE_DATA);
            }
            if (b1 == 0) {
                int b2 = is.read();
                if (b2 == -1) {
                    throw new IOException(ERR_EOL_BEFORE_DATA);
                }
                if (b2 == 0) {
                    JSONEncode jSONEncode = JSONEncode.UTF32LE;
                    return jSONEncode;
                }
                JSONEncode jSONEncode = JSONEncode.UTF16LE;
                return jSONEncode;
            }
            JSONEncode jSONEncode = JSONEncode.UTF8;
            return jSONEncode;
        }
        finally {
            is.reset();
        }
    }

    static enum JSONEncode {
        UTF32BE("UTF-32BE"),
        UTF32LE("UTF-32LE"),
        UTF16BE("UTF-16BE"),
        UTF16LE("UTF-16LE"),
        UTF8("UTF-8");

        String charset;

        private JSONEncode(String charset) {
            this.charset = charset;
        }

        String getCharsetName() {
            return this.charset;
        }
    }
}

