/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.json;

import com.vmware.vide.utils.json.ScannerException;
import com.vmware.vide.utils.json.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class Scanner {
    static final String ERR_UNEXPECTED_CHAR = "Unexpected char [%s].";
    static final String ERR_DIGIT_MISSING_IN_EXP = "A digit missing in the exponent part.";
    static final String ERR_UNEXPECTED_IN_STRING = "Unexpected char [%s] in a string.";
    static final String ERR_UNEXPECTED_IN_NUMBER = "Unexpected char [%s] in a number.";
    BufferedReader br;
    int lastChar;

    Scanner(InputStream is, String charset) throws UnsupportedEncodingException {
        this.br = new BufferedReader(new InputStreamReader(is, charset));
    }

    Token getNextToken() throws IOException, ScannerException {
        int cc = this.getChar();
        if (cc == 123) {
            return Token.BEGIN_OBJECT;
        }
        if (cc == 125) {
            return Token.END_OBJECT;
        }
        if (cc == 91) {
            return Token.BEGIN_ARRAY;
        }
        if (cc == 93) {
            return Token.END_ARRAY;
        }
        if (cc == 58) {
            return Token.NAME_SEPARATOR;
        }
        if (cc == 44) {
            return Token.VALUE_SEPARATOR;
        }
        if (this.isWhiteSpace(cc)) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)cc);
            this.readWhiteSpaces(sb);
            return Token.WHITE_SPACE;
        }
        if (cc == 45 || this.isDigit(cc)) {
            boolean minus = false;
            StringBuilder sbInt = new StringBuilder();
            StringBuilder sbFrac = new StringBuilder();
            StringBuilder sbExp = new StringBuilder();
            if (cc == 45) {
                minus = true;
                cc = this.getChar();
                if (cc == 48) {
                    sbInt.append('0');
                } else if (cc >= 49 && cc <= 57) {
                    sbInt.append((char)cc);
                    this.readInt(sbInt);
                } else {
                    throw new ScannerException(String.format(ERR_UNEXPECTED_CHAR, this.lastChar));
                }
                this.readFrac(sbFrac);
                this.readExp(sbExp);
            } else if (cc == 48) {
                sbInt.append('0');
                this.readFrac(sbFrac);
                this.readExp(sbExp);
            } else {
                sbInt.append((char)cc);
                this.readInt(sbInt);
                this.readFrac(sbFrac);
                this.readExp(sbExp);
            }
            Token.NUMBER.setValue(this.createNumber(minus, sbInt, sbFrac, sbExp));
            return Token.NUMBER;
        }
        if (cc == 34) {
            StringBuilder sb = new StringBuilder();
            this.readString(sb);
            Token.STRING.setValue(sb.toString());
            return Token.STRING;
        }
        if (cc == 102 && this.getChar() == 97 && this.getChar() == 108 && this.getChar() == 115 && this.getChar() == 101) {
            return Token.FALSE;
        }
        if (cc == 116 && this.getChar() == 114 && this.getChar() == 117 && this.getChar() == 101) {
            return Token.TRUE;
        }
        if (cc == 110 && this.getChar() == 117 && this.getChar() == 108 && this.getChar() == 108) {
            return Token.NULL;
        }
        if (cc == -1) {
            return Token.EOS;
        }
        throw new ScannerException(String.format(ERR_UNEXPECTED_CHAR, this.lastChar));
    }

    private Object createNumber(boolean minus, StringBuilder sbInt, StringBuilder sbFrac, StringBuilder sbExp) {
        StringBuilder sb = new StringBuilder();
        if (minus) {
            sb.append('-');
        }
        if (sbFrac.length() != 0 || sbExp.length() != 0) {
            sb.append((CharSequence)sbInt);
            if (sbFrac.length() != 0) {
                sb.append('.');
                sb.append((CharSequence)sbFrac);
            }
            if (sbExp.length() != 0) {
                sb.append('E');
                sb.append((CharSequence)sbExp);
            }
            return Double.valueOf(sb.toString());
        }
        sb.append((CharSequence)sbInt);
        return new BigInteger(sb.toString());
    }

    private int getChar() throws IOException {
        this.lastChar = this.br.read();
        return this.lastChar;
    }

    private boolean isWhiteSpace(int cc) {
        return cc == 32 || cc == 9 || cc == 10 || cc == 13;
    }

    private void readWhiteSpaces(StringBuilder sb) throws IOException {
        while (true) {
            this.br.mark(1);
            int cc = this.getChar();
            if (!this.isWhiteSpace(cc)) break;
            sb.append((char)cc);
        }
        this.br.reset();
    }

    private boolean isDigit(int cc) {
        return cc >= 48 && cc <= 57;
    }

    private void readInt(StringBuilder sb) throws IOException {
        while (true) {
            this.br.mark(1);
            int cc = this.getChar();
            if (!this.isDigit(cc)) break;
            sb.append((char)cc);
        }
        this.br.reset();
    }

    private void readFrac(StringBuilder sb) throws IOException, ScannerException {
        this.br.mark(1);
        int cc = this.getChar();
        if (cc != 46) {
            this.br.reset();
            return;
        }
        this.br.mark(1);
        cc = this.getChar();
        if (!this.isDigit(cc)) {
            this.br.reset();
            throw new ScannerException("A digit missing in the fraction part.");
        }
        sb.append((char)cc);
        this.readInt(sb);
    }

    private void readExp(StringBuilder sb) throws IOException, ScannerException {
        this.br.mark(1);
        int cc = this.getChar();
        if (cc != 101 && cc != 69) {
            this.br.reset();
            return;
        }
        this.br.mark(1);
        cc = this.getChar();
        if (cc == 45 || cc == 43) {
            if (cc == 45) {
                sb.append('-');
            }
            this.br.mark(1);
            cc = this.getChar();
            if (!this.isDigit(cc)) {
                this.br.reset();
                throw new ScannerException(ERR_DIGIT_MISSING_IN_EXP);
            }
        } else if (!this.isDigit(cc)) {
            throw new ScannerException(ERR_DIGIT_MISSING_IN_EXP);
        }
        sb.append((char)cc);
        this.readInt(sb);
    }

    private int convertHexadecimal(int cc) {
        if (cc >= 48 && cc <= 57) {
            return cc - 48;
        }
        if (cc >= 65 && cc <= 70) {
            return cc - 65 + 10;
        }
        if (cc >= 97 && cc <= 102) {
            return cc - 97 + 10;
        }
        return -1;
    }

    private void readString(StringBuilder sb) throws IOException, ScannerException {
        while (true) {
            this.br.mark(1);
            int cc = this.getChar();
            if (cc == 34) {
                return;
            }
            if (cc >= 32 && cc <= 91) {
                sb.append((char)cc);
                continue;
            }
            if (cc >= 93 && cc <= 0x10FFFF) {
                if (Character.isHighSurrogate((char)cc)) {
                    this.br.mark(1);
                    int c2 = this.getChar();
                    if (Character.isLowSurrogate((char)c2)) {
                        sb.appendCodePoint(Character.toCodePoint((char)cc, (char)c2));
                        continue;
                    }
                    this.br.reset();
                    throw new ScannerException("Invalid surrogate pair.");
                }
                sb.append((char)cc);
                continue;
            }
            if (cc != 92) break;
            this.br.mark(1);
            cc = this.getChar();
            if (cc == 34 || cc == 92 || cc == 47) {
                sb.append((char)cc);
                continue;
            }
            if (cc == 98) {
                sb.append('\b');
                continue;
            }
            if (cc == 102) {
                sb.append('\f');
                continue;
            }
            if (cc == 110) {
                sb.append('\n');
                continue;
            }
            if (cc == 114) {
                sb.append('\r');
                continue;
            }
            if (cc == 116) {
                sb.append('\t');
                continue;
            }
            if (cc != 117) break;
            int val = 0;
            int i = 0;
            while (i < 4) {
                this.br.mark(1);
                cc = this.getChar();
                int v = this.convertHexadecimal(cc);
                if (v == -1) {
                    this.br.reset();
                    throw new ScannerException(String.format(ERR_UNEXPECTED_IN_STRING, this.lastChar));
                }
                val <<= 4 + v;
                ++i;
            }
            sb.append((char)val);
        }
        this.br.reset();
        throw new ScannerException(String.format(ERR_UNEXPECTED_IN_STRING, this.lastChar));
    }
}

