/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.local;

import com.vmware.vide.utils.local.CLIListener;
import com.vmware.vide.utils.local.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CLIServerProcess {
    private File cmdFile = null;
    private Process proc;
    private StdIOMonitorThread stderrThread;
    private StdIOMonitorThread stdoutThread;
    public List<CLIListener> stdoutListeners = new ArrayList<CLIListener>();
    public List<CLIListener> stderrListeners = new ArrayList<CLIListener>();

    public Process getProcess() {
        return this.proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStdoutListener(CLIListener listener) {
        List<CLIListener> list = this.stdoutListeners;
        synchronized (list) {
            this.stdoutListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStdoutListener(CLIListener listener) {
        List<CLIListener> list = this.stdoutListeners;
        synchronized (list) {
            this.stdoutListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStderrListener(CLIListener listener) {
        List<CLIListener> list = this.stderrListeners;
        synchronized (list) {
            this.stderrListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStderrListener(CLIListener listener) {
        List<CLIListener> list = this.stderrListeners;
        synchronized (list) {
            this.stderrListeners.remove(listener);
        }
    }

    public Process runServer(String cmd, String cmddir) {
        Runtime runtime = Runtime.getRuntime();
        this.proc = null;
        this.cmdFile = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedErrorReader = null;
        try {
            ArrayList<String> cmdLines = new ArrayList<String>();
            cmdLines.add(cmd);
            this.cmdFile = FileHelper.saveToTempFile("vmwb4eng", ".sh", cmdLines);
            this.cmdFile.setExecutable(true, false);
            File dirFile = null;
            if (cmddir != null && !cmddir.isEmpty()) {
                dirFile = new File(cmddir);
            }
            this.proc = runtime.exec("/bin/sh -c " + this.cmdFile.getAbsolutePath(), null, dirFile);
            InputStream inputstream = this.proc.getInputStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
            bufferedReader = new BufferedReader(inputstreamreader);
            InputStream errorstream = this.proc.getErrorStream();
            InputStreamReader errorstreamreader = new InputStreamReader(errorstream);
            bufferedErrorReader = new BufferedReader(errorstreamreader);
            this.stderrThread = new StdIOMonitorThread(bufferedErrorReader, this.stderrListeners, "stderr");
            this.stderrThread.start();
            this.stdoutThread = new StdIOMonitorThread(bufferedReader, this.stdoutListeners, "stdout");
            this.stdoutThread.start();
            this.sendToStdoutListeners(String.valueOf(cmd) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            if (this.proc != null) {
                this.kill();
            }
            return null;
        }
        return this.proc;
    }

    public void send(String line) {
        OutputStream stdin = this.proc.getOutputStream();
        try {
            stdin.write(line.getBytes());
            stdin.write(10);
            stdin.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int kill() {
        int status = -1;
        if (this.stderrThread != null && this.stderrThread.isAlive()) {
            this.stderrThread.interrupt();
        }
        if (this.stdoutThread != null && this.stdoutThread.isAlive()) {
            this.stdoutThread.interrupt();
        }
        this.proc.destroy();
        try {
            status = this.proc.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.stderrThread != null && this.stderrThread.isAlive()) {
            this.stderrThread.interrupt();
        }
        if (this.stdoutThread != null && this.stdoutThread.isAlive()) {
            this.stdoutThread.interrupt();
        }
        this.proc = null;
        if (this.cmdFile != null && this.cmdFile.exists()) {
            this.cmdFile.delete();
        }
        return status;
    }

    public int waitProcess(final IProgressMonitor monitor) {
        int status = -1;
        Thread killer = null;
        if (monitor != null) {
            killer = new Thread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        do {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                break block3;
                            }
                        } while (!monitor.isCanceled());
                        CLIServerProcess.this.kill();
                    }
                }
            }, "Cancel Monitor Thread");
            killer.start();
        }
        try {
            status = this.proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (killer != null && killer.isAlive()) {
            killer.interrupt();
        }
        if (this.stderrThread != null && this.stderrThread.isAlive()) {
            this.stderrThread.interrupt();
        }
        if (this.stdoutThread != null && this.stdoutThread.isAlive()) {
            this.stdoutThread.interrupt();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToListeners(String line, List<CLIListener> listeners) {
        CLIListener[] array;
        List<CLIListener> list = listeners;
        synchronized (list) {
            array = new CLIListener[listeners.size()];
            listeners.toArray(array);
        }
        CLIListener[] cLIListenerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            CLIListener listener = cLIListenerArray[n2];
            listener.onLineReceived(line);
            ++n2;
        }
    }

    protected void sendToStdoutListeners(String line) {
        this.sendToListeners(line, this.stdoutListeners);
    }

    protected void sendToStderrListeners(String line) {
        this.sendToListeners(line, this.stderrListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminate() {
        List<CLIListener> list = this.stdoutListeners;
        synchronized (list) {
            for (CLIListener listener : this.stdoutListeners) {
                listener.onTerminate();
            }
        }
        list = this.stderrListeners;
        synchronized (list) {
            for (CLIListener listener : this.stderrListeners) {
                listener.onTerminate();
            }
        }
    }

    public class StdIOMonitorThread
    extends Thread {
        private BufferedReader bufferedReader;
        List<CLIListener> listeners;

        public StdIOMonitorThread(BufferedReader br, List<CLIListener> listeners, String streamName) {
            super(String.valueOf(CLIServerProcess.this.cmdFile.getName()) + " " + streamName + " Reader");
            this.bufferedReader = null;
            this.bufferedReader = br;
            this.listeners = listeners;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

