/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.local;

import com.vmware.vide.utils.local.CommandStreamReader;
import com.vmware.vide.utils.local.CommandStreamWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HostCommandRunner {
    protected CommandStreamReader _stdoutReader;
    protected CommandStreamReader _stderrReader;

    public int runCommand(String command) {
        return this.runCommand(command, null, null, null, null, null);
    }

    public int runCommand(String command, File dir, CommandStreamReader stdoutReader, CommandStreamReader stderrReader, CommandStreamWriter stdinWriter, Map<String, String> envUpdates) {
        String[] args = command.split(" ");
        ArrayList<String> cmds = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            cmds.add(args[i]);
            ++i;
        }
        return this.runCommand(cmds, dir, stdoutReader, stderrReader, stdinWriter, envUpdates);
    }

    public int runCommand(List<String> command, File dir, CommandStreamReader stdoutReader, CommandStreamReader stderrReader, CommandStreamWriter stdinWriter, Map<String, String> envUpdates) {
        ProcessBuilder builder = new ProcessBuilder(command);
        if (envUpdates != null) {
            Map<String, String> envs = builder.environment();
            for (Map.Entry<String, String> ent : envUpdates.entrySet()) {
                envs.remove(ent.getKey());
                if (ent.getValue() == null) continue;
                envs.put(ent.getKey(), ent.getValue());
            }
        }
        if (dir != null) {
            builder.directory(dir);
        }
        Process proc = null;
        try {
            proc = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        if (stderrReader == null) {
            stderrReader = new CommandStreamReader(proc.getErrorStream());
        } else {
            stderrReader.setInputStream(proc.getErrorStream());
        }
        if (stdoutReader == null) {
            stdoutReader = new CommandStreamReader();
            stdoutReader.setInputStream(proc.getInputStream());
        } else {
            stdoutReader.setInputStream(proc.getInputStream());
        }
        this._stdoutReader = stdoutReader;
        this._stderrReader = stderrReader;
        stderrReader.start();
        stdoutReader.start();
        if (stdinWriter != null) {
            stdinWriter.setOutputStream(proc.getOutputStream());
            stdinWriter.start();
        }
        int result = -1;
        try {
            stderrReader.join();
            stdoutReader.join();
            if (stdinWriter != null) {
                stdinWriter.join();
            }
            result = proc.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getStdOutResult() {
        return this._stdoutReader.getOutput();
    }

    public String getStdErrResult() {
        return this._stderrReader.getOutput();
    }

    public List<String> getStdOutLines() {
        return this._stdoutReader.getLines();
    }

    public List<String> getStdErrLines() {
        return this._stderrReader.getLines();
    }
}

