/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.local;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class VMWBConfig {
    private static final String WORKBENCH_PRODUCT = "com.vmware.vide.workbench.ide";
    private static final String WORKBENCH_RCP_PRODUCT = "com.vmware.vide.toolsuite.product";

    public static String getInstallDir() {
        Location loc = Platform.getInstallLocation();
        if (loc != null) {
            URL url = loc.getURL();
            File f = new File(url.getPath());
            return f.toString();
        }
        return null;
    }

    public static String getConfigPath(String fileName) {
        String path = String.valueOf(VMWBConfig.getInstallDir()) + fileName;
        File file = new File(path);
        if (file.exists()) {
            return path;
        }
        return fileName;
    }

    public static boolean isHeadless() {
        boolean headless = true;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        if (bundle != null && bundle.getState() == 32) {
            try {
                Class c = bundle.loadClass("org.eclipse.ui.PlatformUI");
                Method method = c.getMethod("isWorkbenchRunning", new Class[0]);
                headless = (Boolean)method.invoke(null, new Object[0]) == false;
            }
            catch (Exception exception) {}
        }
        return headless;
    }

    public static boolean isWorkbenchIde() {
        return WORKBENCH_PRODUCT.equals(System.getProperty("eclipse.product"));
    }

    public static boolean isWorkbenchRCP() {
        return WORKBENCH_RCP_PRODUCT.equals(System.getProperty("eclipse.product"));
    }
}

