/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyManager {
    private Properties properties = new Properties();

    public static PropertyManager getInstance() {
        return PropertyManagerHolder.INSTANCE;
    }

    private PropertyManager() {
    }

    public void init(File file) {
        this.properties.clear();
        if (file != null) {
            try {
                this.properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {}
        }
    }

    public void setPropertiesFromKeyValuePairs(String[] keyValueArray) {
        if (keyValueArray == null) {
            return;
        }
        String[] stringArray = keyValueArray;
        int n = keyValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("--")) {
                arg = arg.substring(2);
            } else if (arg.startsWith("-")) {
                arg = arg.substring(1);
            }
            String[] splitArgs = arg.split("=");
            if (splitArgs.length == 2) {
                this.setString(splitArgs[0], splitArgs[1]);
            }
            ++n2;
        }
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public String getString(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    /* synthetic */ PropertyManager(PropertyManager propertyManager) {
        this();
    }

    private static class PropertyManagerHolder {
        private static final PropertyManager INSTANCE = new PropertyManager(null);

        private PropertyManagerHolder() {
        }
    }
}

