/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.xml;

import com.vmware.vide.utils.xml.XmlPrettyPrinter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;

public class JaxbUtils {
    public static final String NULL_OBJECT_EXCEPTION_MSG = "JAXB Parser returned null object";

    public static <T> T toObject(File fXmlFile, String packageName) throws JAXBException, UnmarshalException, ClassCastException {
        if (!fXmlFile.exists()) {
            throw new JAXBException("XML file '" + fXmlFile.getPath() + "' does not exist");
        }
        JAXBContext ctx = JAXBContext.newInstance((String)packageName);
        Unmarshaller um = ctx.createUnmarshaller();
        Object object = null;
        Object obj = um.unmarshal(fXmlFile);
        if (obj instanceof JAXBElement) {
            JAXBElement jaxBWrapper = (JAXBElement)obj;
            object = jaxBWrapper.getValue();
        } else {
            Object object2;
            object = object2 = obj;
        }
        if (object == null) {
            throw new JAXBException(NULL_OBJECT_EXCEPTION_MSG);
        }
        return (T)object;
    }

    public static <T> T toObject(File fXmlFile, Class ... classesToBeBound) throws JAXBException, UnmarshalException, ClassCastException {
        if (!fXmlFile.exists()) {
            throw new JAXBException("XML file '" + fXmlFile.getPath() + "' does not exist");
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound, Collections.emptyMap());
        Unmarshaller um = ctx.createUnmarshaller();
        Object object = null;
        Object obj = um.unmarshal(fXmlFile);
        if (obj instanceof JAXBElement) {
            JAXBElement jaxBWrapper = (JAXBElement)obj;
            object = jaxBWrapper.getValue();
        } else {
            Object object2;
            object = object2 = obj;
        }
        if (object == null) {
            throw new JAXBException(NULL_OBJECT_EXCEPTION_MSG);
        }
        return (T)object;
    }

    public static <T> T toObject(InputStream inputStream, Class ... classesToBeBound) throws JAXBException, UnmarshalException, ClassCastException {
        if (inputStream == null) {
            throw new JAXBException("inputStream cannot be null");
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound, Collections.emptyMap());
        Unmarshaller um = ctx.createUnmarshaller();
        Object object = null;
        Object obj = um.unmarshal(inputStream);
        if (obj instanceof JAXBElement) {
            JAXBElement jaxBWrapper = (JAXBElement)obj;
            object = jaxBWrapper.getValue();
        } else {
            Object object2;
            object = object2 = obj;
        }
        if (object == null) {
            throw new JAXBException(NULL_OBJECT_EXCEPTION_MSG);
        }
        return (T)object;
    }

    public static <T> void toPrettyXml(Class<T> objectType, File fXmlFile, Object instance, boolean includeXmlHeader) throws Exception {
        JaxbUtils.toPrettyXml(objectType, fXmlFile, instance, includeXmlHeader, false);
    }

    public static <T> void toPrettyXml(Class<T> objectType, File fXmlFile, Object instance, boolean includeXmlHeader, boolean appendToFile) throws Exception {
        FileOutputStream outputFileStream = new FileOutputStream(fXmlFile, appendToFile);
        JaxbUtils.toPrettyXml(objectType, outputFileStream, instance, includeXmlHeader);
        outputFileStream.close();
    }

    public static <T> String toPrettyXml(Class<T> objectType, Object instance, boolean includeXmlHeader) throws Exception {
        ByteArrayOutputStream formattedOutputStream = new ByteArrayOutputStream();
        JaxbUtils.toPrettyXml(objectType, formattedOutputStream, instance, includeXmlHeader);
        return new String(formattedOutputStream.toByteArray());
    }

    public static <T> void toPrettyXml(Class<T> objectType, OutputStream outputStream, Object instance, boolean includeXmlHeader) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objectType});
        Marshaller m = context.createMarshaller();
        ByteArrayOutputStream unformattedOutputStream = new ByteArrayOutputStream();
        m.marshal(instance, (OutputStream)unformattedOutputStream);
        ByteArrayInputStream bais = new ByteArrayInputStream(unformattedOutputStream.toByteArray());
        XmlPrettyPrinter.formatXml(bais, outputStream, includeXmlHeader);
        outputStream.flush();
    }

    public static <T> void toJaxbFormattedXml(Class<T> objectType, File fXmlFile, Object instance, boolean includeXmlHeader, boolean appendToFile) throws Exception {
        FileOutputStream outputFileStream = new FileOutputStream(fXmlFile, appendToFile);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objectType});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal(instance, (OutputStream)outputFileStream);
        outputFileStream.close();
    }

    private JaxbUtils() {
    }
}

