/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLParser {
    public static final XMLParser parser = new XMLParser();

    public boolean generateXMLAfterUpdateValues(File orgxml, String destfile, Map<String, String> updatedvalues) {
        Document dom;
        if (orgxml == null || !orgxml.exists() || destfile == null) {
            return false;
        }
        try {
            dom = this.parseXml(orgxml);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        if (dom != null) {
            if (updatedvalues != null && updatedvalues.size() > 0) {
                for (Map.Entry<String, String> pairs : updatedvalues.entrySet()) {
                    XMLParser.findReplaceNodeValue(dom, pairs.getKey(), pairs.getValue(), true, true, true);
                }
            }
            this.genXML(dom, destfile);
        }
        return true;
    }

    public boolean generateXMLAfterMergeXMLs(String destfile, Object[] xmls) {
        if (destfile == null || xmls.length == 0) {
            return false;
        }
        Document dom = this.mergeXml(xmls, true, true);
        if (dom != null) {
            this.genXML(dom, destfile);
            return true;
        }
        return false;
    }

    public Document mergeXml(Object[] xmls, boolean overwrite, boolean create) {
        Document dom;
        if (xmls == null || xmls.length == 0) {
            return null;
        }
        try {
            dom = this.parseXml(xmls[0]);
            if (xmls.length > 1) {
                int i = 1;
                while (i < xmls.length) {
                    Document updateddom = this.parseXml(xmls[i]);
                    if (updateddom != null) {
                        dom = this.mergeDocument(dom, updateddom, overwrite, create);
                    }
                    ++i;
                }
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        return dom;
    }

    private Document mergeDocument(Document basedom, Document updateddom, boolean overwrite, boolean create) {
        return this.updateDocument(basedom, updateddom.getChildNodes(), overwrite, create);
    }

    private Document updateDocument(Document basedom, NodeList nodes, boolean overwrite, boolean create) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            XMLParser.findReplaceNodeValue(basedom, node.getNodeName(), XMLParser.getTextNodeValue(node), true, overwrite, create);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int j = 0;
                while (j < attributes.getLength()) {
                    this.replaceAttribute(basedom, node.getNodeName(), attributes.item(j).getNodeName(), attributes.item(j).getNodeValue(), overwrite, create);
                    ++j;
                }
            }
            basedom = this.updateDocument(basedom, node.getChildNodes(), overwrite, create);
            ++i;
        }
        return basedom;
    }

    public Document parseXml(Object input) throws SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dbf.setIgnoringComments(true);
            if (input instanceof File) {
                return db.parse((File)input);
            }
            if (input instanceof String) {
                return db.parse((String)input);
            }
            if (input instanceof InputStream) {
                return db.parse((InputStream)input);
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public static boolean replaceNodeValue(Document dom, Node node, String info, boolean overwrite, boolean create) {
        if (info == null || info.equals("")) {
            return false;
        }
        if (node.getFirstChild() == null && create) {
            node.appendChild(dom.createTextNode(info));
        } else if (overwrite || XMLParser.getTextNodeValue(node) == null || XMLParser.getTextNodeValue(node).equals("")) {
            node.getFirstChild().setNodeValue(info);
        }
        return true;
    }

    public static Document findReplaceNodeValue(Document dom, String tagname, String info, boolean replaceall, boolean overwrite, boolean create) {
        if (info == null || info.equals("")) {
            return dom;
        }
        Element docelem = dom.getDocumentElement();
        NodeList nl = docelem.getElementsByTagName(tagname);
        if (nl == null || nl.getLength() == 0) {
            return dom;
        }
        int i = 0;
        while (i < nl.getLength()) {
            XMLParser.replaceNodeValue(dom, nl.item(i), info, overwrite, create);
            if (!replaceall) break;
            ++i;
        }
        return dom;
    }

    public Document replaceAttribute(Document dom, String tagname, String attribute, String info, boolean overwrite, boolean create) {
        if (info == null || info.equals("")) {
            return dom;
        }
        Element docelem = dom.getDocumentElement();
        NodeList nl = docelem.getElementsByTagName(tagname);
        if (nl == null || nl.getLength() == 0) {
            return dom;
        }
        int i = 0;
        while (i < nl.getLength()) {
            Node attrnode = nl.item(i).getAttributes().getNamedItem(attribute);
            if (attrnode != null) {
                if (overwrite || attrnode.getNodeValue() == null || attrnode.getNodeValue().equals("")) {
                    attrnode.setNodeValue(info);
                }
            } else if (create) {
                attrnode = dom.createAttribute(attribute);
                attrnode.setNodeValue(info);
                nl.item(i).appendChild(attrnode);
            }
            ++i;
        }
        return dom;
    }

    public static String getNodeTypeName(Node node) {
        String tname = "?";
        switch (node.getNodeType()) {
            case 2: {
                tname = "attribute";
                break;
            }
            case 4: {
                tname = "cdata section";
                break;
            }
            case 8: {
                tname = "comment";
                break;
            }
            case 11: {
                tname = "document_fragment";
                break;
            }
            case 10: {
                tname = "document_type";
                break;
            }
            case 1: {
                tname = "element";
                break;
            }
            case 6: {
                tname = "entity";
                break;
            }
            case 5: {
                tname = "entity_reference";
                break;
            }
            case 12: {
                tname = "notation";
                break;
            }
            case 3: {
                tname = "text";
            }
        }
        return tname;
    }

    public static void printXMLNodeInfo(Node node, int level) {
        String indent = "";
        int i = 0;
        while (i < level) {
            indent = String.valueOf(indent) + "   ";
            ++i;
        }
        System.out.println(String.valueOf(indent) + "DOM tag:" + node.getNodeName() + ", type:" + node.getNodeType() + " (" + XMLParser.getNodeTypeName(node) + ")");
        if (node.getNodeValue() != null) {
            System.out.println(String.valueOf(indent) + "      value:" + node.getNodeValue());
        }
        i = 0;
        while (i < node.getChildNodes().getLength()) {
            XMLParser.printXMLNodeInfo(node.getChildNodes().item(i), level + 1);
            ++i;
        }
    }

    public static void printXMLInfo(Document dom) {
        System.out.println("DOM tag:" + dom.getNodeName() + ", type:" + dom.getNodeType() + "(" + XMLParser.getNodeTypeName(dom) + ")");
        if (dom.getNodeValue() != null) {
            System.out.println("      value:" + dom.getNodeValue());
        }
        int i = 0;
        while (i < dom.getChildNodes().getLength()) {
            XMLParser.printXMLNodeInfo(dom.getChildNodes().item(i), 1);
            ++i;
        }
    }

    public static boolean saveXML(Document dom, String filename) {
        try {
            DOMSource source = new DOMSource(dom);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(source, result);
            return true;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {}
        return false;
    }

    public boolean genXML(Document dom, String filename) {
        return XMLParser.saveXML(dom, filename);
    }

    public static String toString(Object root) {
        if (root instanceof Document) {
            StringWriter out = new StringWriter();
            OutputFormat of = new OutputFormat((Document)root);
            of.setIndenting(true);
            of.setIndent(2);
            XMLSerializer serializer = new XMLSerializer((Writer)out, of);
            try {
                serializer.serialize((Document)root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return out.toString();
        }
        if (root instanceof Node) {
            try {
                DOMSource source = new DOMSource((Node)root);
                StringWriter outputWriter = new StringWriter();
                StreamResult result = new StreamResult(outputWriter);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                xformer.transform(source, result);
                return outputWriter.toString();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
            }
            catch (TransformerException transformerException) {}
        }
        return null;
    }

    public static boolean isTextNode(Node node) {
        if (node.getFirstChild() == null) {
            return false;
        }
        return node.getFirstChild().getNodeType() == 3;
    }

    public static String getTextNodeValue(Node node) {
        if (!XMLParser.isTextNode(node)) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public static String getFirstTextNodeValueFromTag(Document dom, String tagname) {
        NodeList nl = dom.getElementsByTagName(tagname);
        if (nl != null && nl.getLength() > 0) {
            return XMLParser.getTextNodeValue(nl.item(0));
        }
        return null;
    }

    public static Element createTextElementAndValue(Document doc, Node parent, String tag, String value) {
        Element element;
        block3: {
            element = null;
            try {
                element = doc.createElement(tag);
                if (value != null) {
                    Text text = doc.createTextNode(value);
                    element.appendChild(text);
                }
            }
            catch (Exception exception) {
                element = doc.createElement("Exception");
                element.setAttribute("name", tag);
                if (value == null) break block3;
                Text text = doc.createTextNode(value);
                element.appendChild(text);
            }
        }
        parent.appendChild(element);
        return element;
    }

    public static Element startBlock(Document doc, Node parent, String tag) {
        Element element = doc.createElement(tag);
        parent.appendChild(element);
        return element;
    }
}

