/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vmwbrepository;

import com.vmware.vide.vmwbrepository.ArtifactTag;
import com.vmware.vide.vmwbrepository.service.api.IArtifact;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="artifact")
public class Artifact
implements IArtifact {
    public static final String DEVKIT = "DEVKIT";
    public static final String CERT = "CERT";
    public static final String VMWBPKG = "VMWBPKG";
    public static final String VMKDEBUG = "VMKDEBUG";
    public static final String PLATFORM_VMWB = "VMWB";
    public static final String PLATFORM_RCP_LIN32 = "RCP_LIN32";
    public static final String PLATFORM_RCP_LIN64 = "RCP_LIN64";
    public static final String PLATFORM_RCP_WIN32 = "RCP_WIN32";
    public static final String PLATFORM_RCP_WIN64 = "RCP_WIN64";
    public static final String PLATFORM_RCP_MAC32 = "RCP_MAC32";
    public static final String PLATFORM_RCP_MAC64 = "RCP_MAC64";
    public static final String PLATFORM_RCP_NOARCH = "RCP_NOARCH";
    public static final String PLATFORM_LIN32 = "LIN32";
    public static final String PLATFORM_LIN64 = "LIN64";
    public static final String PLATFORM_WIN32 = "WIN32";
    public static final String PLATFORM_WIN64 = "WIN64";
    public static final String PLATFORM_MAC32 = "MAC32";
    public static final String PLATFORM_MAC64 = "MAC64";
    public static final String PLATFORM_NOARCH = "NOARCH";
    public static final String PLATFORM_ESXI = "ESXI";
    String description;
    String id;
    String name;
    String type;
    String updateUrl;
    String packageUrl;
    int packageSize;
    String docUrl;
    String md5Checksum;
    String workbenchTag;
    String version;
    List<String> platforms;
    List<ArtifactTag> tags;
    boolean redirectDownload;
    boolean ignoreDependencies;

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement
    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public void setUpdateUrl(String updateUrl) {
        this.updateUrl = updateUrl;
    }

    @XmlElement
    public String getPackageUrl() {
        return this.packageUrl;
    }

    public void setPackageUrl(String url) {
        this.packageUrl = url;
    }

    @XmlElement
    public int getPackageSizeInBytes() {
        return this.packageSize;
    }

    public void setPackageSizeInBytes(int size) {
        this.packageSize = size;
    }

    @XmlElement
    public String getDocUrl() {
        return this.docUrl;
    }

    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    @XmlElement
    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public void setMd5Checksum(String md5Checksum) {
        this.md5Checksum = md5Checksum;
    }

    @XmlElement
    public String getWorkbenchTag() {
        return this.workbenchTag;
    }

    public void setWorkbenchTag(String workbenchTag) {
        this.workbenchTag = workbenchTag;
    }

    @XmlElement(name="platform")
    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(List<String> value) {
        this.platforms = value;
    }

    @XmlElement(name="tag")
    public List<ArtifactTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ArtifactTag> value) {
        this.tags = value;
    }

    @XmlElement(name="redirectDownload")
    public void setRedirectDownload(boolean value) {
        this.redirectDownload = value;
    }

    public boolean getRedirectDownload() {
        return this.redirectDownload;
    }

    public boolean IsDevKit() {
        return this.getType().equals(DEVKIT);
    }

    public boolean getIgnoreDependencies() {
        return this.ignoreDependencies;
    }

    public void setIgnoreDependencies(boolean value) {
        this.ignoreDependencies = value;
    }

    public boolean supportsPlatform(String wantedPlatform) {
        if (this.platforms == null || this.platforms.isEmpty()) {
            return true;
        }
        for (String p : this.platforms) {
            if (!p.equalsIgnoreCase(wantedPlatform)) continue;
            return true;
        }
        return false;
    }

    public static String getPlatformDescription(String platform) {
        if (PLATFORM_ESXI.equalsIgnoreCase(platform)) {
            return "VMware ESXi";
        }
        if (PLATFORM_LIN32.equalsIgnoreCase(platform)) {
            return "32-bit Linux";
        }
        if (PLATFORM_LIN64.equalsIgnoreCase(platform)) {
            return "64-bit Linux";
        }
        if (PLATFORM_MAC32.equalsIgnoreCase(platform)) {
            return "32-bit Mac OS";
        }
        if (PLATFORM_MAC64.equalsIgnoreCase(platform)) {
            return "64-bit Mac OS";
        }
        if (PLATFORM_NOARCH.equalsIgnoreCase(platform)) {
            return "Any platform";
        }
        if (PLATFORM_VMWB.equalsIgnoreCase(platform)) {
            return "VMware Workbench VA";
        }
        if (PLATFORM_WIN32.equalsIgnoreCase(platform)) {
            return "32-bit Windows";
        }
        if (PLATFORM_WIN64.equalsIgnoreCase(platform)) {
            return "64-bit Windows";
        }
        if (PLATFORM_RCP_LIN32.equalsIgnoreCase(platform)) {
            return "32-bit Linux Tools Suite";
        }
        if (PLATFORM_RCP_LIN64.equalsIgnoreCase(platform)) {
            return "64-bit Linux Tools Suite";
        }
        if (PLATFORM_RCP_MAC32.equalsIgnoreCase(platform)) {
            return "32-bit Mac OS Tools Suite";
        }
        if (PLATFORM_RCP_MAC64.equalsIgnoreCase(platform)) {
            return "64-bit Mac OS Tools Suite";
        }
        if (PLATFORM_RCP_NOARCH.equalsIgnoreCase(platform)) {
            return "Any Tools Suite platform";
        }
        if (PLATFORM_RCP_WIN32.equalsIgnoreCase(platform)) {
            return "32-bit Windows Tools Suite";
        }
        if (PLATFORM_RCP_WIN64.equalsIgnoreCase(platform)) {
            return "64-bit Windows Tools Suite";
        }
        return "Unknown";
    }

    public Map<String, String> getTagValues() {
        TreeMap<String, String> values = new TreeMap<String, String>();
        if (this.tags != null) {
            for (ArtifactTag tag : this.tags) {
                if (!tag.getIsInternal().equalsIgnoreCase("false")) continue;
                String value = (String)values.get(tag.getCategory());
                value = value != null ? String.valueOf(value) + ", " + tag.getName() : tag.getName();
                values.put(tag.getCategory(), value);
            }
        }
        return values;
    }
}

