/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vmwbrepository;

import com.vmware.vide.vmwbrepository.AccountInfo;
import com.vmware.vide.vmwbrepository.Activator;
import com.vmware.vide.vmwbrepository.Artifact;
import com.vmware.vide.vmwbrepository.ArtifactList;
import com.vmware.vide.vmwbrepository.HTTPClient;
import com.vmware.vide.vmwbrepository.PewebLoginDialog;
import com.vmware.vide.vmwbrepository.ProviderData;
import com.vmware.vide.vmwbrepository.ProviderDataList;
import com.vmware.vide.vmwbrepository.service.impl.WebServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import jcifs.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class WebServiceController {
    private static final String AUTH_SERVICE = "/authService/authenticate/";
    private static final String VMDEV_AUTH = "/authService/authenticate/vmdev";
    private static final String VMWB_AUTH_PROVIDERS = "/authService/authenticationProviders";
    private static final String SERVER_CONFIG_OVERRIDE_FILENAME = "vmwb-server-config.properties";
    private static final String VMWB_TEST_SERVER_VAR = "VMWB_REPOSITORY_SERVER";
    private static final String VMWB_SSL_OVERRIDE_VAR = "VMWB_REPOSITORY_TRUST_ALL_SSL_CERTS";
    private static final String VMWB_TEST_SERVER_PORT_VAR = "VMWB_REPOSITORY_SERVER_PORT";
    private static final String VMWB_TEST_SERVER_ENDPOINT_VAR = "VMWB_REPOSITORY_SERVER_ENDPOINT";
    private static final String PRODUCT_SERVER_NAME = "vdc-repo.vmware.com";
    private static final int PRODUCT_SERVER_PORT = 443;
    private static final String PRODUCT_PROTOCOL = "https";
    private static String ENDPOINT = "api/";
    private static String SERVER_NAME = "vdc-repo.vmware.com";
    private static int SERVER_PORT = 443;
    private static String SERVER_PROTOCOL = "https";
    private static String VMWB_VERSION = "3.5";
    private static String ARTIFACT_STATE = null;
    private static String userName = null;
    private static String password = null;
    private static AccountInfo accountInfo = null;
    private static ILog logger = Activator.getDefault().getLog();
    private static char[] _toHexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private List<Artifact> allArtifacts;
    private List<Artifact> vmwbArtifacts;
    private static boolean isTestEnvironment = false;

    public static boolean isTestEnvironment() {
        return isTestEnvironment;
    }

    public static DefaultHttpClient getDefaultHTTPClient() throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        new HttpHost(SERVER_NAME, SERVER_PORT, PRODUCT_PROTOCOL);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)3000);
        httpClient.setParams((HttpParams)params);
        return httpClient;
    }

    private InputStream getFromURL(String path, String query) throws Exception {
        return this.getFromURL(path, query, userName, password, true);
    }

    private InputStream getFromURL(String path, String query, String userName, String password, boolean isGet) throws Exception {
        URI uri = URIUtils.createURI((String)SERVER_PROTOCOL, (String)SERVER_NAME, (int)SERVER_PORT, (String)path, (String)query, null);
        return this.getFromURL(uri, userName, password, isGet);
    }

    private InputStream getFromURL(URI uri, String userName, String password, boolean isGet) throws Exception {
        InputStream is;
        HttpEntity entity;
        HttpResponse response;
        StatusLine status;
        HttpGet getRequest;
        DefaultHttpClient client = HTTPClient.getDefaultHTTPClient();
        HTTPClient.checkForProxy(client, uri.getHost(), "HTTPS");
        Object object = getRequest = isGet ? new HttpGet(uri) : new HttpPost(uri);
        if (userName != null) {
            String auth = String.valueOf(userName) + ":" + password;
            String encodedString = Base64.encode((byte[])auth.getBytes("UTF-8"));
            getRequest.addHeader("Authorization", "Basic " + encodedString);
        }
        if ((status = (response = client.execute((HttpUriRequest)getRequest)).getStatusLine()).getStatusCode() == 200 && (entity = response.getEntity()) != null && (is = entity.getContent()) != null) {
            return is;
        }
        throw new WebServiceException(status.getStatusCode(), status.getReasonPhrase());
    }

    public synchronized void setCredentials(String name, String passwd) {
        userName = name;
        password = passwd;
    }

    public String getUserName() {
        return userName;
    }

    public String getPassword() {
        return password;
    }

    public ProviderDataList getProviderDataList() throws Exception {
        try (InputStream instream = null;){
            URI uri = URIUtils.createURI((String)PRODUCT_PROTOCOL, (String)PRODUCT_SERVER_NAME, (int)443, (String)VMWB_AUTH_PROVIDERS, (String)"generateSessionToken=false", null);
            instream = this.getFromURL(uri, null, null, true);
            if (instream != null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProviderDataList.class});
                Unmarshaller m = context.createUnmarshaller();
                ProviderDataList providerDataList = (ProviderDataList)m.unmarshal(instream);
                return providerDataList;
            }
        }
        return null;
    }

    public AccountInfo authenticateLogin(String username, String password, ProviderData providerData) throws Exception {
        if (username == null || password == null || providerData == null) {
            return null;
        }
        try (InputStream instream = null;){
            String providerId = AUTH_SERVICE + providerData.getId();
            URI uri = URIUtils.createURI((String)PRODUCT_PROTOCOL, (String)SERVER_NAME, (int)SERVER_PORT, (String)providerId, (String)"generateSessionToken=true", null);
            instream = this.getFromURL(uri, username, password, false);
            if (instream != null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AccountInfo.class});
                Unmarshaller m = context.createUnmarshaller();
                AccountInfo accountInfo = (AccountInfo)m.unmarshal(instream);
                return accountInfo;
            }
        }
        return null;
    }

    public AccountInfo getAccountInfo(String username, String password) throws Exception {
        if (username == null || password == null) {
            return null;
        }
        try (InputStream instream = null;){
            URI uri = URIUtils.createURI((String)PRODUCT_PROTOCOL, (String)PRODUCT_SERVER_NAME, (int)443, (String)VMDEV_AUTH, (String)"generateSessionToken=false", null);
            instream = this.getFromURL(uri, username, password, false);
            if (instream != null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AccountInfo.class});
                Unmarshaller m = context.createUnmarshaller();
                AccountInfo accountInfo = (AccountInfo)m.unmarshal(instream);
                return accountInfo;
            }
        }
        return null;
    }

    public boolean requestCredentials(String name, String passwd) {
        boolean needInput;
        String errormsg = null;
        boolean bl = needInput = name == null || passwd == null;
        while (true) {
            if (needInput) {
                PewebLoginDialog login = PewebLoginDialog.openDialog(name, passwd, errormsg);
                if (login == null) {
                    return false;
                }
                name = login.username;
                passwd = login.password;
            }
            try {
                accountInfo = this.getAccountInfo(name, passwd);
                if (accountInfo == null) continue;
                this.setCredentials(name, passwd);
                return true;
            }
            catch (Exception exception) {
                errormsg = "Invalid Login:";
                needInput = true;
                continue;
            }
            break;
        }
    }

    public void getArtifacts(List<Artifact> artCollector, String workbenchTag, String type) throws Exception {
        String endpoint = ENDPOINT;
        if (workbenchTag != null && !workbenchTag.isEmpty()) {
            endpoint = String.valueOf(endpoint) + workbenchTag + "/";
        }
        endpoint = String.valueOf(endpoint) + type + "/artifacts";
        InputStream instream = this.getFromURL(endpoint, ARTIFACT_STATE);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ArtifactList.class});
            Unmarshaller m = context.createUnmarshaller();
            ArtifactList artifacts = (ArtifactList)m.unmarshal(instream);
            if (artifacts != null && artifacts.getArtifacts() != null) {
                artCollector.addAll(artifacts.getArtifacts());
            }
        }
        catch (Throwable throwable) {
            try {
                instream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            instream.close();
        }
        catch (Exception exception) {}
    }

    public void getArtifacts(List<Artifact> artCollector, String type) throws Exception {
        this.getArtifacts(artCollector, VMWB_VERSION, type);
    }

    public Artifact getArtifact(String ident, boolean credentialsRequired) throws Exception {
        if (credentialsRequired) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    WebServiceController.this.requestCredentials(userName, password);
                }
            });
            if (userName == null || password == null) {
                throw new Exception("Authentication failed.");
            }
        }
        String endpoint = String.valueOf(ENDPOINT) + ident;
        Artifact artifact = null;
        try (InputStream instream = this.getFromURL(endpoint, null);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Artifact.class});
            Unmarshaller m = context.createUnmarshaller();
            artifact = (Artifact)m.unmarshal(instream);
        }
        return artifact;
    }

    public Artifact getArtifactRaw(String endpoint) throws Exception {
        Artifact artifact = null;
        try (InputStream instream = this.getFromURL(endpoint, ARTIFACT_STATE);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Artifact.class});
            Unmarshaller m = context.createUnmarshaller();
            artifact = (Artifact)m.unmarshal(instream);
        }
        return artifact;
    }

    public List<Artifact> getArtifacts() throws Exception {
        this.allArtifacts = new ArrayList<Artifact>();
        if (userName != null) {
            this.getArtifacts(this.allArtifacts, "cert");
            this.getArtifacts(this.allArtifacts, "devkit");
            this.getArtifacts(this.allArtifacts, "none", "vmkdebug");
        } else {
            this.getArtifacts(this.allArtifacts, "cert/open");
            this.getArtifacts(this.allArtifacts, "devkit/open");
            this.getArtifacts(this.allArtifacts, "none", "vmkdebug/open");
        }
        return this.allArtifacts;
    }

    public List<Artifact> getDependencies(String id) throws Exception {
        List<Artifact> arts = null;
        InputStream instream = this.getFromURL(String.valueOf(ENDPOINT) + "artifact/" + id + "/dependencies", null);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ArtifactList.class});
            Unmarshaller m = context.createUnmarshaller();
            ArtifactList artifacts = (ArtifactList)m.unmarshal(instream);
            arts = artifacts.getArtifacts();
        }
        catch (Throwable throwable) {
            try {
                instream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            instream.close();
        }
        catch (Exception exception) {}
        return arts;
    }

    public List<Artifact> getVMWBPackagesArtifacts() throws Exception {
        this.vmwbArtifacts = new ArrayList<Artifact>();
        if (this.vmwbArtifacts.isEmpty()) {
            if (userName != null) {
                this.getArtifacts(this.vmwbArtifacts, "vmwbpkg");
            } else {
                this.getArtifacts(this.vmwbArtifacts, "vmwbpkg/open");
            }
        }
        return this.vmwbArtifacts;
    }

    public byte[] getRosaSecurityKey(String buildno) throws Exception {
        StringBuilder sb = new StringBuilder("rosakey/");
        sb.append(buildno);
        return this.getArtifactPackageBytes(sb.toString());
    }

    public byte[] getRosaSecurityIV(String buildno) throws Exception {
        StringBuilder sb = new StringBuilder("rosaiv/");
        sb.append(buildno);
        return this.getArtifactPackageBytes(sb.toString());
    }

    private byte[] getArtifactPackageBytes(String artifactPath) throws Exception {
        Artifact artifact = this.getArtifact(artifactPath, true);
        if (artifact.packageSize > 0 && artifact.packageUrl != null) {
            URL url = new URL(artifact.packageUrl);
            InputStream is = this.getFromURL(url.toURI(), userName, password, true);
            byte[] buffer = new byte[artifact.packageSize];
            is.read(buffer);
            String sum = this.toHex(MessageDigest.getInstance("MD5").digest(buffer));
            if (sum.equalsIgnoreCase(artifact.getMd5Checksum())) {
                return buffer;
            }
            String expect = artifact.getMd5Checksum();
            String msg = String.format("MD5 checksum error on the package[%s]. Expected [%s], got [%s]", url.toString(), expect, sum);
            throw new Exception(msg);
        }
        throw new Exception("No package");
    }

    private String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            sb.append(_toHexChar[b >> 4 & 0xF]);
            sb.append(_toHexChar[b & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public String getTextualContent(String name) {
        InputStream instream = null;
        try {
            instream = this.getFromURL(name, null);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)instream, (Writer)writer, (String)"UTF-8");
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            String msg = String.format("Failed to read from %s", name);
            logger.log((IStatus)new Status(4, "com.vmware.vide.peweb", msg, (Throwable)e));
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.peweb", "", (Throwable)e));
                }
            }
        }
        return null;
    }
}

