﻿/*
 * Copyright 2014, 2016 VMware, Inc.  All rights reserved.
 */

namespace vmware.samples.common
{
    using System;

    /// <summary>
    /// Management node services helper.
    /// </summary>
    public class ManagementNode
    {
        private SamplesBase sample;

        public PlatformServiceController PlatformServiceController { get; private set; }
        public VapiConnection VapiConnection { get; private set; }
        public VimConnection VimConnection { get; private set; }

        public ManagementNode(SamplesBase sample)
        {
            if (string.IsNullOrWhiteSpace(sample.LsUrl))
                throw new ArgumentException("Lookup service URL is null or empty string.");
            if (string.IsNullOrWhiteSpace(sample.SsoUserName))
                throw new ArgumentException("SSO UserName is null or empty string.");
            if (string.IsNullOrWhiteSpace(sample.SsoPassword))
                throw new ArgumentException("SSO Password is null or empty string.");

            this.sample = sample;
            this.PlatformServiceController = new PlatformServiceController();
        }

        public void Connect(string mgmtNodeName)
        {
            // connect to infrastructure node
            PlatformServiceController.Connect(sample.LsUrl, sample.SsoUserName,
                sample.SsoPassword);

            // find management node ID
            var nodeId = PlatformServiceController.GetManagementNodeId(ref
                mgmtNodeName);

            Console.WriteLine("Using management node: " + mgmtNodeName);

            // get SSO connection
            var ssoConnection = PlatformServiceController.SsoConnection;

            // connect to vAPI service
            var vapiUrl = PlatformServiceController.FindVapiUrl(nodeId);
            VapiConnection = new VapiConnection(vapiUrl);
            VapiConnection.Login(ssoConnection);
            Console.WriteLine(VapiConnection);

            // connect to VIM service
            var vimUrl = PlatformServiceController.FindVimUrl(nodeId);
            VimConnection = new VimConnection(vimUrl);
            VimConnection.Login(ssoConnection);
            Console.WriteLine(VimConnection);
        }

        public void Disconnect()
        {
            VapiConnection.Logout();
            if (VimConnection != null)
            {
                VimConnection.Logout();
            }
        }
    }
}
