﻿/*
 * Copyright 2015, 2016 VMware, Inc.  All rights reserved.
 */

namespace vmware.samples.common
{
    using vmware.sso;
    using System.Configuration;
    using System.Security.Cryptography;
    using System.Security.Cryptography.X509Certificates;
    using System.Xml;
    using vmware.vapi.util.security;
    using vmware.vim25;
    using System;

    /// <summary>
    /// Single Sign-On utility.
    /// </summary>
    public class SsoConnection
    {
        private string ssoUrl;

        public RequestSecurityTokenResponseType RequestSecurityTokenResponse
        { get; private set; }
        public SamlToken SamlToken { get; private set; }
        public XmlElement SamlTokenXml { get; private set; }
        public X509Certificate2 X509Certificate { get; private set; }
        public AsymmetricAlgorithm PrivateKey
        {
            get
            {
                if (X509Certificate != null)
                    return X509Certificate.PrivateKey;
                return null;
            }
        }

        public SsoConnection(string ssoUrl)
        {
            this.ssoUrl = ssoUrl;
        }

        public SamlToken AcquireSamlToken(string ssoUserName, string ssoPassword,
            SamlTokenConfirmationType tokenType)
        {
            if (tokenType == SamlTokenConfirmationType.BEARER)
            {
                // get Bearer token
                var rstr = SamlTokenHelper.GetBearerToken(
                    ssoUrl, ssoUserName, ssoPassword);

                this.RequestSecurityTokenResponse = rstr;
                this.SamlTokenXml = rstr.RequestedSecurityToken;
                this.SamlToken = new SamlToken(this.SamlTokenXml);

                return this.SamlToken;
            }
            else
            {
                throw new Exception(
                    "Holder of Key token based authentication is not supported.");
            }
        }

        public override string ToString()
        {
            return string.Format("SSO Connection ({0})", ssoUrl);
        }
    }
}
