﻿
/*
 * Copyright 2016 VMware, Inc.  All rights reserved.
 */
namespace vmware.samples.vcenter.helpers
{
    using System;
    using System.Collections.Generic;
    using vmware.samples.common;
    using vmware.vcenter;
    using vmware.vapi.bindings;

    public class DatastoreHelper
    {
        /// <summary>
        /// Returns the identifier of a datastore.
        ///
        /// Note: The method assumes that there is only one datacenter and
        /// datastore with the specified names.
        /// </summary>
        /// <param name="serviceManager">Helper for instantiating vapi services</param>
        /// <param name="datacenterName">name of the datacenter</param>
        /// <param name="datastoreName">name of the datastore</param>
        /// <returns>identifier of a datastore</returns>
        public static String GetDatastore(
            ManagementNode serviceManager, String datacenterName,
            String datastoreName)
        {
            HashSet<string> datacenters = new HashSet<string>
            {
                DatacenterHelper.GetDatacenter(serviceManager, datacenterName)
            };
            DatastoreTypes.FilterSpec dsFilterSpec =
                new DatastoreTypes.FilterSpec();
            dsFilterSpec.SetNames(new HashSet<String> { datastoreName });
            dsFilterSpec.SetDatacenters(datacenters);

            Datastore datastoreService =
                serviceManager.VapiConnection.GetService<Datastore>();
            List<DatastoreTypes.Summary> dsSummaries =
                datastoreService.List(dsFilterSpec);

            if (dsSummaries.Count > 1)
            {
                throw new Exception(String.Format("More than one datastore" +
                    " with the specified name {0} exist", datastoreName));
            }

            if (dsSummaries.Count <= 0)
            {
                throw new Exception(String.Format("Datastore with name {0}" +
                                    "not found !", datastoreName));
            }

            return dsSummaries[0].GetDatastore();
        }
    }
}
