/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ParametersHelper {
    private Map<Option, Boolean> optionMap = new LinkedHashMap<Option, Boolean>();

    public ParametersHelper(List<Option> optionList) {
        for (Option option : optionList) {
            this.optionMap.put(option, option.isRequired());
        }
    }

    public Map<String, Object> parse(String[] args) throws ParseException, ConfigurationException {
        Object optionValue;
        Option option;
        HashMap<String, Object> parsedOptions = new HashMap<String, Object>();
        if (args.length == 0) {
            this.printUsage();
        }
        ArrayList<Object> optionsToParseFromCmdLine = new ArrayList();
        ArrayList<Option> optionsToParseFromConfig = new ArrayList<Option>();
        Iterator<Option> optionIter = this.optionMap.keySet().iterator();
        while (optionIter.hasNext()) {
            Option option2 = (Option)optionIter.next().clone();
            option2.setRequired(false);
            optionsToParseFromConfig.add(option2);
        }
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.getOptions(optionsToParseFromConfig), args);
        Iterator optionsIter = optionsToParseFromConfig.iterator();
        if (cmd.hasOption("config-file")) {
            PropertiesConfiguration config = new PropertiesConfiguration(args[1]);
            while (optionsIter.hasNext()) {
                option = (Option)optionsIter.next();
                optionValue = this.getOptionValueFromConfig(option, (Configuration)config);
                if (optionValue == null || optionValue.toString().isEmpty()) {
                    option.setRequired(this.optionMap.get(option).booleanValue());
                    optionsToParseFromCmdLine.add(option);
                    continue;
                }
                option.setRequired(false);
                optionsToParseFromCmdLine.add(option);
                parsedOptions.put(option.getLongOpt(), optionValue);
            }
        } else {
            optionsToParseFromCmdLine = new ArrayList<Option>(this.optionMap.keySet());
        }
        optionsIter = optionsToParseFromCmdLine.iterator();
        CommandLine cmdOverrideArgs = parser.parse(this.getOptions(optionsToParseFromCmdLine), args);
        while (optionsIter.hasNext()) {
            option = (Option)optionsIter.next();
            optionValue = this.getOptionValueFromCmdLine(option, cmdOverrideArgs);
            if (optionValue == null || optionValue.toString().isEmpty()) continue;
            parsedOptions.put(option.getLongOpt(), optionValue);
        }
        return parsedOptions;
    }

    private Options getOptions(List<Option> optionList) {
        Iterator<Option> optionIter = optionList.iterator();
        Options options = new Options();
        while (optionIter.hasNext()) {
            options.addOption(optionIter.next());
        }
        return options;
    }

    private Object getOptionValueFromConfig(Option option, Configuration config) {
        Object optionValue = null;
        try {
            if (option.getType().equals(Boolean.class)) {
                optionValue = config.getString(option.getLongOpt());
                if (optionValue != null) {
                    optionValue = config.getBoolean(option.getLongOpt());
                }
            } else {
                optionValue = config.getString(option.getLongOpt());
            }
        }
        catch (ConversionException cex) {
            optionValue = null;
        }
        return optionValue;
    }

    private Object getOptionValueFromCmdLine(Option option, CommandLine cmd) {
        Object optionValue = null;
        if (!option.hasArg()) {
            if (cmd.hasOption(option.getLongOpt())) {
                optionValue = true;
            }
        } else {
            optionValue = cmd.getOptionValue(option.getLongOpt());
        }
        return optionValue;
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new Comparator<Option>(){

            @Override
            public int compare(Option option1, Option option2) {
                return 0;
            }
        });
        formatter.printHelp(150, "\n./run.sh | run.bat packagename.SampleClassName", "\nSample Options:", this.getOptions(new ArrayList<Option>(this.optionMap.keySet())), "", true);
        System.exit(0);
    }
}

