/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import vmware.samples.common.TrustAllTrustManager;

public class SslUtil {
    public static KeyStore createTrustStoreForServer(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = 443;
        }
        return SslUtil.createTrustStoreForServer(host, port);
    }

    public static KeyStore createTrustStoreForServer(String host, int port) {
        X509TrustManager trustAll = new X509TrustManager(){

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustAll}, null);
            SSLSocket s = (SSLSocket)ctx.getSocketFactory().createSocket(host, port);
            Certificate[] chain = s.getSession().getPeerCertificates();
            Certificate rootCert = chain[chain.length - 1];
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setCertificateEntry(host, rootCert);
            return trustStore;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void trustAllHttpsCertificates() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[1];
            TrustAllTrustManager tm = new TrustAllTrustManager();
            trustAllCerts[0] = tm;
            SSLContext sc = SSLContext.getInstance("SSL");
            SSLSessionContext sslsc = sc.getServerSessionContext();
            sslsc.setSessionTimeout(0);
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate loadCertificate(String filePath) throws IOException, CertificateException {
        ByteArrayInputStream bis = new ByteArrayInputStream(Files.readAllBytes(Paths.get(filePath, new String[0])));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadTrustStore(String filePath, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (FileInputStream truststoreStream = new FileInputStream(filePath);){
            trustStore.load(truststoreStream, password.toCharArray());
            KeyStore keyStore = trustStore;
            return keyStore;
        }
    }
}

