/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common.vim.helpers;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import vmware.samples.common.vim.helpers.WaitForValues;

public class VmVappPowerOps {
    private final VimPortType vimPort;
    private final ServiceContent serviceContent;
    private final WaitForValues waitForValues;

    public VmVappPowerOps(VimPortType vimPort, ServiceContent serviceContent) {
        this.vimPort = vimPort;
        this.serviceContent = serviceContent;
        this.waitForValues = new WaitForValues(vimPort, serviceContent);
    }

    public boolean powerOnVM(String vmName, ManagedObjectReference vmMor) {
        System.out.println("Powering on virtual machine : " + vmName + "[" + vmMor.getValue() + "]");
        try {
            ManagedObjectReference taskmor = this.vimPort.powerOnVMTask(vmMor, null);
            if (this.waitForValues.getTaskResultAfterDone(taskmor)) {
                System.out.println(vmName + "[" + vmMor.getValue() + "] powered on successfully");
                return true;
            }
            System.out.println("Unable to poweron vm : " + vmName + "[" + vmMor.getValue() + "]");
            return false;
        }
        catch (Exception e) {
            System.out.println("Unable to poweron vm : " + vmName + "[" + vmMor.getValue() + "]");
            System.out.println("Reason :" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean powerOffVM(String vmName, ManagedObjectReference vmMor) {
        System.out.println("Powering off virtual machine : " + vmName + "[" + vmMor.getValue() + "]");
        try {
            ManagedObjectReference taskmor = this.vimPort.powerOffVMTask(vmMor);
            if (this.waitForValues.getTaskResultAfterDone(taskmor)) {
                System.out.println(vmName + "[" + vmMor.getValue() + "] powered off successfully");
                return true;
            }
            System.out.println("Unable to poweroff vm : " + vmName + "[" + vmMor.getValue() + "]");
            return false;
        }
        catch (Exception e) {
            System.out.println("Unable to poweroff vm : " + vmName + "[" + vmMor.getValue() + "]");
            System.out.println("Reason :" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean powerOnVApp(String vAppName, ManagedObjectReference vAppMor) {
        System.out.println("Powering on Virtual App : " + vAppName + "[" + vAppMor.getValue() + "]");
        try {
            ManagedObjectReference taskmor = this.vimPort.powerOnVAppTask(vAppMor);
            if (this.waitForValues.getTaskResultAfterDone(taskmor)) {
                System.out.println(vAppName + "[" + vAppMor.getValue() + "] powered on successfully");
                return true;
            }
            System.out.println("Unable to poweron vApp : " + vAppName + "[" + vAppMor.getValue() + "]");
            return false;
        }
        catch (Exception e) {
            System.out.println("Unable to poweron vApp : " + vAppName + "[" + vAppMor.getValue() + "]");
            System.out.println("Reason :" + e.getLocalizedMessage());
            return false;
        }
    }

    public boolean powerOffVApp(String vAppName, ManagedObjectReference vAppMor) {
        System.out.println("Powering off Virtual App : " + vAppName + "[" + vAppMor.getValue() + "]");
        try {
            ManagedObjectReference taskmor = this.vimPort.powerOffVAppTask(vAppMor, true);
            if (this.waitForValues.getTaskResultAfterDone(taskmor)) {
                System.out.println(vAppName + "[" + vAppMor.getValue() + "] powered off successfully");
                return true;
            }
            System.out.println("Unable to poweroff vApp : " + vAppName + "[" + vAppMor.getValue() + "]");
            return false;
        }
        catch (Exception e) {
            System.out.println("Unable to poweroff vApp : " + vAppName + "[" + vAppMor.getValue() + "]");
            System.out.println("Reason :" + e.getLocalizedMessage());
            return false;
        }
    }
}

