/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common.vim.helpers;

import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.WaitOptions;
import java.util.Arrays;
import java.util.List;

public class WaitForValues {
    private final VimPortType vimPort;
    private final ServiceContent serviceContent;

    public WaitForValues(VimPortType vimPort, ServiceContent serviceContent) {
        this.vimPort = vimPort;
        this.serviceContent = serviceContent;
    }

    public boolean getTaskResultAfterDone(ManagedObjectReference task) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean retVal = false;
        Object[] result = this.wait(task, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (result[0].equals(TaskInfoState.SUCCESS)) {
            retVal = true;
        }
        if (result[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)result[1]).getLocalizedMessage());
        }
        return retVal;
    }

    public Object[] wait(ManagedObjectReference objmor, String[] filterProps, String[] endWaitProps, Object[][] expectedVals) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        String version = "";
        Object[] endVals = new Object[endWaitProps.length];
        Object[] filterVals = new Object[filterProps.length];
        PropertyFilterSpec spec = this.propertyFilterSpec(objmor, filterProps);
        ManagedObjectReference filterSpecRef = this.vimPort.createFilter(this.serviceContent.getPropertyCollector(), spec, true);
        boolean reached = false;
        UpdateSet updateset = null;
        List filtupary = null;
        List objupary = null;
        List propchgary = null;
        while (!reached) {
            updateset = this.vimPort.waitForUpdatesEx(this.serviceContent.getPropertyCollector(), version, new WaitOptions());
            if (updateset == null || updateset.getFilterSet() == null) continue;
            version = updateset.getVersion();
            filtupary = updateset.getFilterSet();
            for (PropertyFilterUpdate filtup : filtupary) {
                objupary = filtup.getObjectSet();
                for (ObjectUpdate objup : objupary) {
                    if (objup.getKind() != ObjectUpdateKind.MODIFY && objup.getKind() != ObjectUpdateKind.ENTER && objup.getKind() != ObjectUpdateKind.LEAVE) continue;
                    propchgary = objup.getChangeSet();
                    for (PropertyChange propchg : propchgary) {
                        this.updateValues(endWaitProps, endVals, propchg);
                        this.updateValues(filterProps, filterVals, propchg);
                    }
                }
            }
            Object expctdval = null;
            for (int chgi = 0; chgi < endVals.length && !reached; ++chgi) {
                for (int vali = 0; vali < expectedVals[chgi].length && !reached; ++vali) {
                    expctdval = expectedVals[chgi][vali];
                    reached = expctdval.equals(endVals[chgi]) || reached;
                }
            }
        }
        this.vimPort.destroyPropertyFilter(filterSpecRef);
        return filterVals;
    }

    private PropertyFilterSpec propertyFilterSpec(ManagedObjectReference objmor, String[] filterProps) {
        PropertyFilterSpec spec = new PropertyFilterSpec();
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(objmor);
        oSpec.setSkip(Boolean.FALSE);
        spec.getObjectSet().add(oSpec);
        PropertySpec pSpec = new PropertySpec();
        pSpec.getPathSet().addAll(Arrays.asList(filterProps));
        pSpec.setType(objmor.getType());
        spec.getPropSet().add(pSpec);
        return spec;
    }

    private void updateValues(String[] props, Object[] vals, PropertyChange propchg) {
        for (int findi = 0; findi < props.length; ++findi) {
            if (propchg.getName().lastIndexOf(props[findi]) < 0) continue;
            vals[findi] = propchg.getOp() == PropertyChangeOp.REMOVE ? "" : propchg.getVal();
        }
    }
}

