/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.contentupdate;

import com.vmware.content.LibraryTypes;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.item.UpdateSessionModel;
import com.vmware.content.library.item.updatesession.FileTypes;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.cli.Option;
import org.apache.commons.lang.StringUtils;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.contentlibrary.client.ClsApiClient;
import vmware.samples.contentlibrary.helpers.ItemUploadHelper;

public class ContentUpdate
extends SamplesAbstractBase {
    private static final String OVF_ITEM_TYPE = "ovf";
    private static final String ISO_ITEM_TYPE = "iso";
    private static final String OVF_ITEM_ONE_FOLDER_NAME = "simpleVmTemplate";
    private static final String OVF_ITEM_ONE_OVF_FILE_NAME = "descriptor.ovf";
    private static final String OVF_ITEM_ONE_VMDK_FILE_NAME = "disk-0.vmdk";
    private static final String OVF_ITEM_TWO_FOLDER_NAME = "plainVmTemplate";
    private static final String OVF_ITEM_TWO_OVF_FILE_NAME = "plain-vm.ovf";
    private static final String OVF_ITEM_TWO_VMDK_FILE_NAME = "plain-vm.vmdk";
    private static final String ISO_ITEM_FOLDER_NAME = "isoImages";
    private static final String ISO_ITEM_ONE_ISO_FILE_NAME = "test.iso";
    private static final String ISO_ITEM_TWO_ISO_FILE_NAME = "small.iso";
    private String libName;
    private String ovfItemName = "simpleVmTemplate";
    private String isoItemName = "smallIso";
    private ClsApiClient client;
    private String ovfItemId;
    private String isoItemId;

    @Override
    protected void parseArgs(String[] args) {
        Option libNameOption = Option.builder().longOpt("contentlibraryname").desc("The name of the content library where the library item will be created.").required(true).hasArg().argName("CONTENT LIBRARY").build();
        List<Option> optionList = Collections.singletonList(libNameOption);
        super.parseArgs(optionList, args);
        this.libName = (String)this.parsedOptions.get("contentlibraryname");
    }

    @Override
    protected void setup() throws Exception {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
    }

    @Override
    protected void run() throws Exception {
        assert (StringUtils.isNotBlank((String)this.libName)) : "Local library name must be provided";
        LibraryTypes.FindSpec findSpec = new LibraryTypes.FindSpec();
        findSpec.setName(this.libName);
        List libraryIds = this.client.libraryService().find(findSpec);
        assert (!libraryIds.isEmpty()) : "Unable to find a library with name: " + this.libName;
        String libraryId = (String)libraryIds.get(0);
        System.out.println("Found library : " + libraryId);
        this.ovfItemId = this.createOvfItem(libraryId);
        ItemModel ovfItem = this.client.itemService().get(this.ovfItemId);
        String contentVersionBeforeUpdate = ovfItem.getContentVersion();
        System.out.println("OVF Library Item Created : " + this.ovfItemId + ", content version: " + contentVersionBeforeUpdate);
        UpdateSessionModel updateSessionModel = new UpdateSessionModel();
        updateSessionModel.setLibraryItemId(this.ovfItemId);
        String sessionId = this.client.updateSession().create(null, updateSessionModel);
        List existingFiles = this.client.updateSessionFileService().list(sessionId);
        for (FileTypes.Info fileInfo : existingFiles) {
            this.client.updateSessionFileService().remove(sessionId, fileInfo.getName());
        }
        Map<String, String> filePathMap = this.getVmTemplateFiles(OVF_ITEM_TWO_FOLDER_NAME, OVF_ITEM_TWO_OVF_FILE_NAME, OVF_ITEM_TWO_VMDK_FILE_NAME);
        ItemUploadHelper.uploadFile(this.client.updateSessionFileService(), sessionId, OVF_ITEM_TWO_OVF_FILE_NAME, filePathMap.get(OVF_ITEM_TWO_OVF_FILE_NAME));
        ItemUploadHelper.uploadFile(this.client.updateSessionFileService(), sessionId, OVF_ITEM_TWO_VMDK_FILE_NAME, filePathMap.get(OVF_ITEM_TWO_VMDK_FILE_NAME));
        this.client.updateSession().complete(sessionId);
        ovfItem = this.client.itemService().get(this.ovfItemId);
        String contentVersionAfterUpdate = ovfItem.getContentVersion();
        System.out.println("OVF Library Item Updated : " + this.ovfItemId + ", content version: " + contentVersionAfterUpdate);
        assert (Integer.parseInt(contentVersionBeforeUpdate) + 1 == Integer.parseInt(contentVersionAfterUpdate));
        this.isoItemId = this.createIsoItem(libraryId);
        ItemModel isoItem = this.client.itemService().get(this.isoItemId);
        contentVersionBeforeUpdate = isoItem.getContentVersion();
        System.out.println("ISO Library Item Created : " + this.isoItemId + ", content version: " + contentVersionBeforeUpdate);
        updateSessionModel = new UpdateSessionModel();
        updateSessionModel.setLibraryItemId(this.isoItemId);
        sessionId = this.client.updateSession().create(null, updateSessionModel);
        String isoFilePath = this.getIsoFile(ISO_ITEM_FOLDER_NAME, ISO_ITEM_TWO_ISO_FILE_NAME);
        ItemUploadHelper.uploadFile(this.client.updateSessionFileService(), sessionId, ISO_ITEM_ONE_ISO_FILE_NAME, isoFilePath);
        this.client.updateSession().complete(sessionId);
        isoItem = this.client.itemService().get(this.isoItemId);
        contentVersionAfterUpdate = isoItem.getContentVersion();
        System.out.println("ISO Library Item Updated : " + this.isoItemId + ", content version: " + contentVersionAfterUpdate);
        assert (Integer.parseInt(contentVersionBeforeUpdate) + 1 == Integer.parseInt(contentVersionAfterUpdate));
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.ovfItemId != null) {
            System.out.println("Deleting Library Item : " + this.ovfItemId);
            this.client.itemService().delete(this.ovfItemId);
        }
        if (this.isoItemId != null) {
            System.out.println("Deleting Library Item : " + this.isoItemId);
            this.client.itemService().delete(this.isoItemId);
        }
    }

    private String createOvfItem(String libraryId) throws IOException {
        ItemModel ovfLibItem = this.createLibraryItem(libraryId, this.ovfItemName, OVF_ITEM_TYPE);
        Map<String, String> filePathMap = this.getVmTemplateFiles(OVF_ITEM_ONE_FOLDER_NAME, OVF_ITEM_ONE_OVF_FILE_NAME, OVF_ITEM_ONE_VMDK_FILE_NAME);
        List<String> fileLocations = Arrays.asList(filePathMap.get(OVF_ITEM_ONE_OVF_FILE_NAME), filePathMap.get(OVF_ITEM_ONE_VMDK_FILE_NAME));
        ItemUploadHelper.performUpload(this.client.updateSession(), this.client.updateSessionFileService(), this.client.itemService(), ovfLibItem.getId(), fileLocations);
        assert (ovfLibItem != null);
        assert (this.client.itemService().list(libraryId).size() > 0);
        return ovfLibItem.getId();
    }

    private String createIsoItem(String libraryId) throws IOException {
        String isoFilePath = this.getIsoFile(ISO_ITEM_FOLDER_NAME, ISO_ITEM_ONE_ISO_FILE_NAME);
        ItemModel isoLibItem = this.createLibraryItem(libraryId, this.isoItemName, ISO_ITEM_TYPE);
        ItemUploadHelper.performUpload(this.client.updateSession(), this.client.updateSessionFileService(), this.client.itemService(), isoLibItem.getId(), Arrays.asList(isoFilePath));
        assert (isoLibItem != null);
        assert (this.client.itemService().list(libraryId).size() > 0);
        return isoLibItem.getId();
    }

    private Map<String, String> getVmTemplateFiles(String folderName, String ovfFileName, String diskFileName) throws IOException {
        HashMap<String, String> filePathMap = new HashMap<String, String>();
        File tempDir = ItemUploadHelper.createTempDir(folderName);
        String ovfFile = ItemUploadHelper.copyResourceToFile(folderName + "/" + ovfFileName, tempDir, ovfFileName);
        filePathMap.put(ovfFileName, ovfFile);
        String vmdkFile = ItemUploadHelper.copyResourceToFile(folderName + "/" + diskFileName, tempDir, diskFileName);
        filePathMap.put(diskFileName, vmdkFile);
        System.out.println("OVF Path : " + ovfFile);
        System.out.println("VMDK Path : " + vmdkFile);
        return filePathMap;
    }

    private String getIsoFile(String folderName, String isoFileName) throws IOException {
        File tempDir = ItemUploadHelper.createTempDir(folderName);
        String isoFile = ItemUploadHelper.copyResourceToFile(folderName + "/" + isoFileName, tempDir, isoFileName);
        System.out.println("Iso Image Path : " + isoFile);
        return isoFile;
    }

    private ItemModel createLibraryItem(String libraryId, String libItemName, String itemType) {
        ItemModel libItemSpec = this.getLibraryItemSpec(libraryId, libItemName, "item update", itemType);
        String libItemId = this.client.itemService().create(UUID.randomUUID().toString(), libItemSpec);
        return this.client.itemService().get(libItemId);
    }

    private ItemModel getLibraryItemSpec(String libraryId, String name, String description, String type) {
        ItemModel libItemSpec = new ItemModel();
        libItemSpec.setName(name);
        libItemSpec.setDescription(description);
        libItemSpec.setLibraryId(libraryId);
        libItemSpec.setType(type);
        return libItemSpec;
    }

    public static void main(String[] args) throws Exception {
        new ContentUpdate().execute(args);
    }
}

