/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.ovfimport;

import com.vmware.content.LibraryTypes;
import com.vmware.content.library.ItemModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.contentlibrary.client.ClsApiClient;
import vmware.samples.contentlibrary.helpers.ItemDownloadHelper;
import vmware.samples.contentlibrary.helpers.ItemUploadHelper;

public class OvfImportExport
extends SamplesAbstractBase {
    private String libName;
    private String libItemName = "simpleVmTemplate";
    private ClsApiClient client;
    private ItemModel libItem;

    @Override
    protected void parseArgs(String[] args) {
        Option libNameOption = Option.builder().longOpt("contentlibraryname").desc("The name of the content library where the library item will be created. Defaults to demo-local-lib").required(true).hasArg().argName("CONTENT LIBRARY").build();
        List<Option> optionList = Arrays.asList(libNameOption);
        super.parseArgs(optionList, args);
        this.libName = (String)this.parsedOptions.get("contentlibraryname");
    }

    @Override
    protected void setup() {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
    }

    @Override
    protected void run() throws IOException {
        File tempDir = ItemUploadHelper.createTempDir("simpleVmTemplate");
        String ovfFile = ItemUploadHelper.copyResourceToFile("simpleVmTemplate/descriptor.ovf", tempDir, "descriptor.ovf");
        String vmdkFile = ItemUploadHelper.copyResourceToFile("simpleVmTemplate/disk-0.vmdk", tempDir, "disk-0.vmdk");
        System.out.println("OVF Path : " + ovfFile);
        System.out.println("VMDK Path : " + vmdkFile);
        LibraryTypes.FindSpec findSpec = new LibraryTypes.FindSpec();
        findSpec.setName(this.libName);
        List libraryIds = this.client.libraryService().find(findSpec);
        assert (!libraryIds.isEmpty()) : "Unable to find a library with name: " + this.libName;
        String libraryId = (String)libraryIds.get(0);
        System.out.println("Found library : " + libraryId);
        ItemModel createSpec = new ItemModel();
        createSpec.setName(this.libItemName);
        createSpec.setLibraryId(libraryId);
        createSpec.setType("ovf");
        String clientToken = UUID.randomUUID().toString();
        String libItemId = this.client.itemService().create(clientToken, createSpec);
        this.libItem = this.client.itemService().get(libItemId);
        System.out.println("Library item created : " + this.libItem.getId());
        ItemUploadHelper.performUpload(this.client.updateSession(), this.client.updateSessionFileService(), this.client.itemService(), this.libItem.getId(), Arrays.asList(ovfFile, vmdkFile));
        System.out.println("Uploaded files : " + this.client.storageService().list(this.libItem.getId()));
        File downloadDir = ItemUploadHelper.createTempDir("simpleVmTemplate");
        ItemDownloadHelper.performDownload(this.client.downloadSessionService(), this.client.downloadSessionFileService(), this.client.itemService(), this.libItem.getId(), downloadDir);
        System.out.println("Downloaded files to directory : " + downloadDir);
    }

    @Override
    protected void cleanup() {
        if (this.libItem != null) {
            this.client.itemService().delete(this.libItem.getId());
            System.out.println("Deleted library item : " + this.libItem.getId());
        }
    }

    public static void main(String[] args) throws Exception {
        new OvfImportExport().execute(args);
    }
}

