/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.publishsubscribe;

import com.vmware.content.LibraryModel;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.PublishInfo;
import com.vmware.content.library.StorageBacking;
import com.vmware.content.library.SubscriptionInfo;
import com.vmware.vim25.ManagedObjectReference;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.vim.helpers.VimUtil;
import vmware.samples.contentlibrary.client.ClsApiClient;
import vmware.samples.contentlibrary.helpers.ClsApiHelper;
import vmware.samples.contentlibrary.helpers.ItemUploadHelper;

public class LibraryPublishSubscribe
extends SamplesAbstractBase {
    private static final String VCSP_USERNAME = "vcsp";
    private static final char[] DEMO_PASSWORD = "Password!23".toCharArray();
    private static final long SYNC_TIMEOUT_SEC = 60L;
    private String dsName;
    private String pubLibName = "demo-publib";
    private String subLibName = "demo-sublib";
    private ClsApiClient client;
    private ClsApiHelper clsHelper;
    private String pubLibId;
    private String subLibId;

    @Override
    protected void parseArgs(String[] args) {
        Option dsNameOption = Option.builder().longOpt("datastore").desc("The name of the VC datastore to be used for the published and subscribed libraries.").required(true).hasArg().argName("DATASTORE").build();
        List<Option> optionList = Collections.singletonList(dsNameOption);
        super.parseArgs(optionList, args);
        this.dsName = (String)this.parsedOptions.get("datastore");
    }

    @Override
    protected void setup() throws Exception {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
        this.clsHelper = new ClsApiHelper(this.client);
    }

    @Override
    protected void run() throws Exception {
        StorageBacking storageBacking = this.createStorageBacking();
        PublishInfo pubInfo = new PublishInfo();
        pubInfo.setPublished(Boolean.valueOf(true));
        pubInfo.setAuthenticationMethod(PublishInfo.AuthenticationMethod.BASIC);
        pubInfo.setPassword(DEMO_PASSWORD);
        LibraryModel pubSpec = new LibraryModel();
        pubSpec.setName(this.pubLibName);
        pubSpec.setType(LibraryModel.LibraryType.LOCAL);
        pubSpec.setPublishInfo(pubInfo);
        pubSpec.setStorageBackings(Collections.singletonList(storageBacking));
        String pubToken = UUID.randomUUID().toString();
        this.pubLibId = this.client.localLibraryService().create(pubToken, pubSpec);
        System.out.println("Published library created : " + this.pubLibId);
        LibraryModel pubLib = this.client.localLibraryService().get(this.pubLibId);
        System.out.println("Publish URL : " + pubLib.getPublishInfo().getPublishUrl());
        this.createLibraryItem(this.pubLibId, "item 1");
        SubscriptionInfo subInfo = new SubscriptionInfo();
        subInfo.setAuthenticationMethod(SubscriptionInfo.AuthenticationMethod.BASIC);
        subInfo.setUserName(VCSP_USERNAME);
        subInfo.setPassword(DEMO_PASSWORD);
        subInfo.setOnDemand(Boolean.valueOf(false));
        subInfo.setAutomaticSyncEnabled(Boolean.valueOf(true));
        subInfo.setSubscriptionUrl(pubLib.getPublishInfo().getPublishUrl());
        LibraryModel subSpec = new LibraryModel();
        subSpec.setName(this.subLibName);
        subSpec.setType(LibraryModel.LibraryType.SUBSCRIBED);
        subSpec.setSubscriptionInfo(subInfo);
        subSpec.setStorageBackings(Collections.singletonList(storageBacking));
        String subToken = UUID.randomUUID().toString();
        this.subLibId = this.client.subscribedLibraryService().create(subToken, subSpec);
        LibraryModel subLib = this.client.subscribedLibraryService().get(this.subLibId);
        System.out.println("Subscribed library created : " + this.subLibId);
        boolean syncSuccess = this.clsHelper.waitForLibrarySync(this.pubLibId, this.subLibId, 60L, TimeUnit.SECONDS);
        assert (syncSuccess) : "Timed out while waiting for sync success";
        subLib = this.client.subscribedLibraryService().get(this.subLibId);
        System.out.println("Subscribed library synced : " + subLib.getLastSyncTime().getTime());
        List subItemIds = this.client.itemService().list(this.subLibId);
        assert (subItemIds.size() == 1) : "Subscribed library has one item";
        this.createLibraryItem(pubLib.getId(), "item 2");
        this.client.subscribedLibraryService().sync(this.subLibId);
        syncSuccess = this.clsHelper.waitForLibrarySync(this.pubLibId, this.subLibId, 60L, TimeUnit.SECONDS);
        assert (syncSuccess) : "Timed out while waiting for sync success";
        subLib = this.client.subscribedLibraryService().get(this.subLibId);
        System.out.println("Subscribed library synced : " + subLib.getLastSyncTime().getTime());
        subItemIds = this.client.itemService().list(this.subLibId);
        assert (subItemIds.size() == 2) : "Subscribed library has two items";
        for (String subItemId : subItemIds) {
            ItemModel subItem = this.client.itemService().get(subItemId);
            System.out.println("Subscribed item : " + subItem);
        }
        subInfo.setOnDemand(Boolean.valueOf(true));
        this.client.subscribedLibraryService().update(this.subLibId, subSpec);
        String subItemId = (String)subItemIds.get(0);
        this.client.subscribedItemService().evict(subItemId);
        ItemModel subItem = this.client.itemService().get(subItemId);
        System.out.println("Subscribed item evicted : " + subItem);
        assert (!subItem.getCached().booleanValue()) : "Subscribed item is not cached";
        this.client.subscribedItemService().sync(subItemId, true);
        syncSuccess = this.clsHelper.waitForItemSync(subItemId, 60L, TimeUnit.SECONDS);
        assert (syncSuccess) : "Timed out while waiting for sync success";
        subItem = this.client.itemService().get(subItemId);
        System.out.println("Subscribed item force synced : " + subItem);
        assert (subItem.getCached().booleanValue()) : "Subscribed item is cached";
    }

    @Override
    protected void cleanup() {
        if (this.subLibId != null) {
            this.client.subscribedLibraryService().delete(this.subLibId);
            System.out.println("Deleted subscribed library : " + this.subLibId);
        }
        if (this.pubLibId != null) {
            this.client.localLibraryService().delete(this.pubLibId);
            System.out.println("Deleted published library : " + this.pubLibId);
        }
    }

    private StorageBacking createStorageBacking() {
        ManagedObjectReference dsMoref = VimUtil.getEntityByName(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.dsName, "Datastore");
        assert (dsMoref != null);
        System.out.println("Datastore MoRef : " + dsMoref.getType() + " : " + dsMoref.getValue());
        StorageBacking storageBacking = new StorageBacking();
        storageBacking.setType(StorageBacking.Type.DATASTORE);
        storageBacking.setDatastoreId(dsMoref.getValue());
        return storageBacking;
    }

    private String createLibraryItem(String localLibraryId, String itemName) throws IOException {
        ItemModel createSpec = new ItemModel();
        createSpec.setLibraryId(localLibraryId);
        createSpec.setName(itemName);
        String clientToken = UUID.randomUUID().toString();
        String libItemId = this.client.itemService().create(clientToken, createSpec);
        Path path = Files.createTempFile(itemName, ".txt", new FileAttribute[0]);
        path.toFile().deleteOnExit();
        String content = "Contents of " + itemName;
        Files.write(path, content.getBytes(), new OpenOption[0]);
        ItemUploadHelper.performUpload(this.client.updateSession(), this.client.updateSessionFileService(), this.client.itemService(), libItemId, Arrays.asList(path.toString()));
        System.out.println("Library item created : " + libItemId);
        return libItemId;
    }

    public static void main(String[] args) throws Exception {
        new LibraryPublishSubscribe().execute(args);
    }
}

