/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.vmcapture;

import com.vmware.content.LibraryModel;
import com.vmware.content.library.ItemTypes;
import com.vmware.content.library.StorageBacking;
import com.vmware.vcenter.ovf.LibraryItemTypes;
import com.vmware.vim25.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.vim.helpers.VimUtil;
import vmware.samples.contentlibrary.client.ClsApiClient;

public class VmTemplateCapture
extends SamplesAbstractBase {
    private String contentLibraryName;
    private String dataStoreName;
    private String vmName;
    private ClsApiClient client;
    private String libItemName;
    private String libraryId;

    @Override
    protected void parseArgs(String[] args) {
        Option dataStoreNameOption = Option.builder().longOpt("datastore").desc("The name of the datastore for content library backing (of type vmfs)").required(true).hasArg().argName("DATASTORE").build();
        Option vmNameOption = Option.builder().longOpt("vmname").desc("The Name of the vm to be captured").required(true).hasArg().argName("VM NAME").build();
        List<Option> optionList = Arrays.asList(dataStoreNameOption, vmNameOption);
        super.parseArgs(optionList, args);
        this.dataStoreName = (String)this.parsedOptions.get("datastore");
        this.vmName = (String)this.parsedOptions.get("vmname");
        this.contentLibraryName = "LocalLibraryToCapture";
        this.libItemName = "capturedItem";
    }

    @Override
    protected void setup() throws Exception {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
    }

    @Override
    protected void run() throws Exception {
        ManagedObjectReference dsMoref = VimUtil.getEntityByName(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.dataStoreName, "Datastore");
        assert (dsMoref != null);
        System.out.println("Datastore MoRef : " + dsMoref.getType() + " : " + dsMoref.getValue());
        this.libraryId = this.createLocalLib(dsMoref);
        this.captureVM(this.libraryId);
        ItemTypes.FindSpec findSpec = new ItemTypes.FindSpec();
        findSpec.setName(this.libItemName);
        List itemIds = this.client.itemService().find(findSpec);
        assert (!itemIds.isEmpty()) : "Unable to find captured library item with name: " + this.libItemName;
        String itemId = (String)itemIds.get(0);
        System.out.println("The VM : " + this.vmName + " is captured as library item  : " + itemId + " of type vm-template.");
    }

    private void captureVM(String libraryId) throws Exception {
        String entityType = "VirtualMachine";
        ManagedObjectReference entityId = VimUtil.getVM(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.vmName);
        LibraryItemTypes.DeployableIdentity deployable = new LibraryItemTypes.DeployableIdentity();
        deployable.setType(entityType);
        deployable.setId(entityId.getValue());
        LibraryItemTypes.CreateTarget target = new LibraryItemTypes.CreateTarget();
        target.setLibraryId(libraryId);
        LibraryItemTypes.CreateSpec spec = new LibraryItemTypes.CreateSpec();
        spec.setName(this.libItemName);
        spec.setDescription("VM template created from a VM capture");
        LibraryItemTypes.CreateResult result = this.client.ovfLibraryItemService().create(null, deployable, target, spec);
        if (result.getSucceeded()) {
            System.out.println("The vm capture to content library succeeded");
        } else {
            System.out.println("The vm capture to content library failed");
        }
    }

    private String createLocalLib(ManagedObjectReference dsMoref) {
        StorageBacking storage = new StorageBacking();
        storage.setType(StorageBacking.Type.DATASTORE);
        storage.setDatastoreId(dsMoref.getValue());
        LibraryModel createSpec = new LibraryModel();
        createSpec.setName(this.contentLibraryName);
        createSpec.setDescription("Local library backed by VC datastore");
        createSpec.setType(LibraryModel.LibraryType.LOCAL);
        createSpec.setStorageBackings(Collections.singletonList(storage));
        String clientToken = UUID.randomUUID().toString();
        String libraryId = this.client.localLibraryService().create(clientToken, createSpec);
        System.out.println("Local library created : " + libraryId);
        return libraryId;
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.libraryId != null) {
            this.client.localLibraryService().delete(this.libraryId);
            System.out.println("Deleted library : " + this.libraryId);
        }
    }

    public static void main(String[] args) throws Exception {
        new VmTemplateCapture().execute(args);
    }
}

