/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso.externalpsc;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.saml.SamlToken;
import com.vmware.vcenter.Datacenter;
import com.vmware.vcenter.DatacenterTypes;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.authentication.VapiAuthenticationHelper;
import vmware.samples.sso.LookupServiceHelper;
import vmware.samples.sso.SsoHelper;

public class ExternalPscSsoWorkflow
extends SamplesAbstractBase {
    private String lookupServiceUrl;
    private Datacenter datacenterService;
    public static final String SSO_PATH = "/sts/STSService";

    @Override
    public void parseArgs(String[] args) {
        Option lookupServiceUrlOption = Option.builder().longOpt("lookupserviceurl").desc("url of the lookup service").argName("LOOKUP SERVICE URL").required(true).hasArg().build();
        List<Option> optionList = Arrays.asList(lookupServiceUrlOption);
        super.parseArgs(optionList, args);
        this.lookupServiceUrl = (String)this.parsedOptions.get("lookupserviceurl");
    }

    @Override
    protected void setup() throws Exception {
    }

    @Override
    public void run() throws Exception {
        System.out.println("\n\n#### Example: Login to vCenter server with external Platform Services Controller.");
        this.vapiAuthHelper = new VapiAuthenticationHelper();
        KeyStore trustStore = this.setupSslTrustForServer();
        System.out.println("\nStep 1: Connect to the lookup service on the Platform Services Controller node.");
        LookupServiceHelper lookupServiceHelper = new LookupServiceHelper(this.lookupServiceUrl);
        System.out.println("\nStep 2: Discover the Single Sign-On service URL from lookup service.");
        String ssoUrl = lookupServiceHelper.findSsoUrl();
        System.out.println("\nStep 3: Connect to the Single Sign-On URL and retrieve the SAML bearer token.");
        SamlToken samlBearerToken = SsoHelper.getSamlBearerToken(ssoUrl, this.username, this.password);
        System.out.println("\nStep 4. Login to vAPI services using the SAML bearer token.");
        StubConfiguration sessionStubConfig = this.vapiAuthHelper.loginBySamlBearerToken(this.server, samlBearerToken, trustStore);
        System.out.println("\nStep 5: Perform certain tasks using the vAPI services.");
        this.datacenterService = (Datacenter)this.vapiAuthHelper.getStubFactory().createStub(Datacenter.class, (StubConfigurationBase)sessionStubConfig);
        System.out.println("\nList of datacenters on the vcenter server:\n" + this.datacenterService.list(new DatacenterTypes.FilterSpec()));
        this.vapiAuthHelper.logout();
    }

    @Override
    protected void cleanup() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        ExternalPscSsoWorkflow externalPscSsoWorkflow = null;
        externalPscSsoWorkflow = new ExternalPscSsoWorkflow();
        externalPscSsoWorkflow.parseArgs(args);
        externalPscSsoWorkflow.run();
    }
}

