/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.create.basicvm;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.VM;
import com.vmware.vcenter.VMTypes;
import com.vmware.vcenter.vm.GuestOS;
import com.vmware.vcenter.vm.hardware.DiskTypes;
import com.vmware.vcenter.vm.hardware.EthernetTypes;
import com.vmware.vcenter.vm.hardware.ScsiAddressSpec;
import com.vmware.vcenter.vm.hardware.boot.DeviceTypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.NetworkHelper;
import vmware.samples.vcenter.helpers.PlacementHelper;

public class CreateBasicVM
extends SamplesAbstractBase {
    private String vmFolderName;
    private String datastoreName;
    private String datacenterName;
    private String clusterName;
    private String standardPortgroupName;
    private static final String BASIC_VM_NAME = "Sample-Basic-VM";
    private GuestOS vmGuestOS = GuestOS.WINDOWS_9_64;
    private VM vmService;
    private String basicVMId;

    @Override
    protected void parseArgs(String[] args) {
        Option datacenterOption = Option.builder().longOpt("datacenter").desc("The name of the datacenter on which to create the vm.").argName("DATACENTER").required(true).hasArg().build();
        Option vmFolderOption = Option.builder().longOpt("vmfolder").desc("The name of the vm folder on which to create the vm.").argName("VM FOLDER").required(true).hasArg().build();
        Option datastoreOption = Option.builder().longOpt("datastore").desc("The name of the datastore on which to create the vm").required(true).argName("DATASTORE").hasArg().build();
        Option clusterOption = Option.builder().longOpt("cluster").desc("The name of the cluster on which to create the vm.").argName("CLUSTER").required(true).hasArg().build();
        Option stdPortgroupOption = Option.builder().longOpt("standardportgroup").desc("The name of the standard portgroup").argName("STANDARD PORTGROUP").required(true).hasArg().build();
        List<Option> optionList = Arrays.asList(vmFolderOption, datastoreOption, datacenterOption, clusterOption, stdPortgroupOption);
        super.parseArgs(optionList, args);
        this.vmFolderName = (String)this.parsedOptions.get("vmfolder");
        this.datastoreName = (String)this.parsedOptions.get("datastore");
        this.datacenterName = (String)this.parsedOptions.get("datacenter");
        this.clusterName = (String)this.parsedOptions.get("cluster");
        this.standardPortgroupName = (String)this.parsedOptions.get("standardportgroup");
    }

    @Override
    protected void setup() throws Exception {
        this.vmService = (VM)this.vapiAuthHelper.getStubFactory().createStub(VM.class, (StubConfigurationBase)this.sessionStubConfig);
    }

    @Override
    protected void run() throws Exception {
        VMTypes.PlacementSpec vmPlacementSpec = PlacementHelper.getPlacementSpecForCluster(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.clusterName, this.vmFolderName, this.datastoreName);
        String standardNetworkBacking = NetworkHelper.getStandardNetworkBacking(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.standardPortgroupName);
        this.createBasicVM(vmPlacementSpec, standardNetworkBacking);
    }

    private void createBasicVM(VMTypes.PlacementSpec vmPlacementSpec, String standardNetworkBacking) {
        DiskTypes.CreateSpec bootDiskCreateSpec = new DiskTypes.CreateSpec.Builder().setType(DiskTypes.HostBusAdapterType.SCSI).setScsi(new ScsiAddressSpec.Builder(0L).setUnit(Long.valueOf(0L)).build()).setNewVmdk(new DiskTypes.VmdkCreateSpec()).build();
        DiskTypes.CreateSpec dataDiskCreateSpec = new DiskTypes.CreateSpec.Builder().setNewVmdk(new DiskTypes.VmdkCreateSpec()).build();
        List<DiskTypes.CreateSpec> disks = Arrays.asList(bootDiskCreateSpec, dataDiskCreateSpec);
        EthernetTypes.BackingSpec nicBackingSpec = new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.STANDARD_PORTGROUP).setNetwork(standardNetworkBacking).build();
        EthernetTypes.CreateSpec nicCreateSpec = new EthernetTypes.CreateSpec.Builder().setStartConnected(Boolean.valueOf(true)).setBacking(nicBackingSpec).build();
        List<EthernetTypes.CreateSpec> nics = Collections.singletonList(nicCreateSpec);
        List<DeviceTypes.EntryCreateSpec> bootDevices = Arrays.asList(new DeviceTypes.EntryCreateSpec.Builder(DeviceTypes.Type.ETHERNET).build(), new DeviceTypes.EntryCreateSpec.Builder(DeviceTypes.Type.DISK).build());
        VMTypes.CreateSpec vmCreateSpec = new VMTypes.CreateSpec.Builder(this.vmGuestOS).setName(BASIC_VM_NAME).setBootDevices(bootDevices).setPlacement(vmPlacementSpec).setNics(nics).setDisks(disks).build();
        System.out.println("\n\n#### Example: Creating Basic VM with spec:\n" + vmCreateSpec);
        this.basicVMId = this.vmService.create(vmCreateSpec);
        VMTypes.Info vmInfo = this.vmService.get(this.basicVMId);
        System.out.println("\nBasic VM Info:\n" + vmInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.basicVMId != null) {
            System.out.println("\n\n#### Deleting the Basic VM");
            this.vmService.delete(this.basicVMId);
        }
    }

    public static void main(String[] args) throws Exception {
        new CreateBasicVM().execute(args);
    }
}

