/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.create.exhaustivevm;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.VM;
import com.vmware.vcenter.VMTypes;
import com.vmware.vcenter.vm.GuestOS;
import com.vmware.vcenter.vm.HardwareTypes;
import com.vmware.vcenter.vm.hardware.CdromTypes;
import com.vmware.vcenter.vm.hardware.CpuTypes;
import com.vmware.vcenter.vm.hardware.DiskTypes;
import com.vmware.vcenter.vm.hardware.EthernetTypes;
import com.vmware.vcenter.vm.hardware.FloppyTypes;
import com.vmware.vcenter.vm.hardware.MemoryTypes;
import com.vmware.vcenter.vm.hardware.ParallelTypes;
import com.vmware.vcenter.vm.hardware.ScsiAddressSpec;
import com.vmware.vcenter.vm.hardware.SerialTypes;
import com.vmware.vcenter.vm.hardware.boot.DeviceTypes;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.NetworkHelper;
import vmware.samples.vcenter.helpers.PlacementHelper;

public class CreateExhaustiveVM
extends SamplesAbstractBase {
    private String vmFolderName;
    private String datastoreName;
    private String datacenterName;
    private String clusterName;
    private String standardPortgroupName;
    private String distributedPortgroupName;
    private String isoDatastorePath;
    private VM vmService;
    private static final String EXHAUSTIVE_VM_NAME = "Sample-Exhaustive-VM";
    private static final String SERIAL_PORT_NETWORK_SERVICE_LOCATION = "tcp://localhost:16000";
    private static final long GB = 0x40000000L;
    private GuestOS vmGuestOS = GuestOS.WINDOWS_9_64;
    private HardwareTypes.Version HARDWARE_VERSION = HardwareTypes.Version.VMX_11;
    private String exhaustiveVMId;

    @Override
    protected void parseArgs(String[] args) {
        Option vmFolderOption = Option.builder().longOpt("vmfolder").desc("The name of the vm folder on which to create the vm.").argName("VM FOLDER").required(true).hasArg().build();
        Option datastoreOption = Option.builder().longOpt("datastore").desc("The name of the datastore on which to create the vm").required(true).argName("DATASTORE").hasArg().build();
        Option datacenterOption = Option.builder().longOpt("datacenter").desc("The name of the datacenter on which to create the vm.").argName("DATACENTER").required(true).hasArg().build();
        Option clusterOption = Option.builder().longOpt("cluster").desc("The name of the cluster on which to create the vm.").argName("CLUSTER").required(true).hasArg().build();
        Option stdPortgroupOption = Option.builder().longOpt("standardportgroup").desc("The name of the standard portgroup").argName("STANDARD PORTGROUP").required(true).hasArg().build();
        Option distributedPortgroupOption = Option.builder().longOpt("distributedportgroup").desc("The name of the distributed portgroup").argName("DISTRIBUTED PORTGROUP").required(true).hasArg().build();
        Option isoDatastorePathOption = Option.builder().longOpt("isodatastorepath").desc("The path to the iso file on the datastore").argName("ISO DATASTORE PATH").required(true).hasArg().build();
        List<Option> optionList = Arrays.asList(vmFolderOption, datastoreOption, datacenterOption, clusterOption, stdPortgroupOption, distributedPortgroupOption, isoDatastorePathOption);
        super.parseArgs(optionList, args);
        this.vmFolderName = (String)this.parsedOptions.get("vmfolder");
        this.datastoreName = (String)this.parsedOptions.get("datastore");
        this.datacenterName = (String)this.parsedOptions.get("datacenter");
        this.clusterName = (String)this.parsedOptions.get("cluster");
        this.standardPortgroupName = (String)this.parsedOptions.get("standardportgroup");
        this.distributedPortgroupName = (String)this.parsedOptions.get("distributedportgroup");
        this.isoDatastorePath = (String)this.parsedOptions.get("isodatastorepath");
    }

    @Override
    protected void setup() throws Exception {
        this.vmService = (VM)this.vapiAuthHelper.getStubFactory().createStub(VM.class, (StubConfigurationBase)this.sessionStubConfig);
    }

    @Override
    protected void run() throws Exception {
        VMTypes.PlacementSpec vmPlacementSpec = PlacementHelper.getPlacementSpecForCluster(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.clusterName, this.vmFolderName, this.datastoreName);
        String standardNetworkBacking = NetworkHelper.getStandardNetworkBacking(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.standardPortgroupName);
        String distributedNetworkBacking = NetworkHelper.getDistributedNetworkBacking(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.distributedPortgroupName);
        this.createExhaustiveVM(vmPlacementSpec, standardNetworkBacking, distributedNetworkBacking);
    }

    private void createExhaustiveVM(VMTypes.PlacementSpec vmPlacementSpec, String standardNetworkBacking, String distributedNetworkBacking) {
        CpuTypes.UpdateSpec cpuUpdateSpec = new CpuTypes.UpdateSpec.Builder().setCoresPerSocket(Long.valueOf(1L)).setHotAddEnabled(Boolean.valueOf(false)).setHotRemoveEnabled(Boolean.valueOf(false)).build();
        MemoryTypes.UpdateSpec memoryUpdateSpec = new MemoryTypes.UpdateSpec.Builder().setSizeMiB(Long.valueOf(2048L)).setHotAddEnabled(Boolean.valueOf(false)).build();
        DiskTypes.CreateSpec diskCreateSpec1 = new DiskTypes.CreateSpec.Builder().setType(DiskTypes.HostBusAdapterType.SCSI).setScsi(new ScsiAddressSpec.Builder(0L).setUnit(Long.valueOf(0L)).build()).setNewVmdk(new DiskTypes.VmdkCreateSpec.Builder().setName("boot").setCapacity(Long.valueOf(0xA00000000L)).build()).build();
        DiskTypes.CreateSpec diskCreateSpec2 = new DiskTypes.CreateSpec.Builder().setNewVmdk(new DiskTypes.VmdkCreateSpec.Builder().setName("data1").setCapacity(Long.valueOf(0x280000000L)).build()).build();
        DiskTypes.CreateSpec diskCreateSpec3 = new DiskTypes.CreateSpec.Builder().setNewVmdk(new DiskTypes.VmdkCreateSpec.Builder().setName("data2").setCapacity(Long.valueOf(0x280000000L)).build()).build();
        EthernetTypes.CreateSpec manualEthernetSpec = new EthernetTypes.CreateSpec.Builder().setStartConnected(Boolean.valueOf(true)).setMacType(EthernetTypes.MacAddressType.MANUAL).setMacAddress("11:23:58:13:21:34").setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.STANDARD_PORTGROUP).setNetwork(standardNetworkBacking).build()).build();
        EthernetTypes.CreateSpec generatedEthernetSpec = new EthernetTypes.CreateSpec.Builder().setStartConnected(Boolean.valueOf(true)).setMacType(EthernetTypes.MacAddressType.GENERATED).setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.DISTRIBUTED_PORTGROUP).setNetwork(distributedNetworkBacking).build()).build();
        CdromTypes.CreateSpec cdromCreateSpec = new CdromTypes.CreateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(CdromTypes.BackingType.ISO_FILE).setIsoFile(this.isoDatastorePath).build()).build();
        SerialTypes.CreateSpec serialCreateSpec = new SerialTypes.CreateSpec.Builder().setStartConnected(Boolean.valueOf(false)).setBacking(new SerialTypes.BackingSpec.Builder(SerialTypes.BackingType.NETWORK_SERVER).setNetworkLocation(URI.create(SERIAL_PORT_NETWORK_SERVICE_LOCATION)).build()).build();
        ParallelTypes.CreateSpec parallelCreateSpec = new ParallelTypes.CreateSpec.Builder().setStartConnected(Boolean.valueOf(false)).setBacking(new ParallelTypes.BackingSpec.Builder(ParallelTypes.BackingType.HOST_DEVICE).build()).build();
        FloppyTypes.CreateSpec floppyCreateSpec = new FloppyTypes.CreateSpec.Builder().setBacking(new FloppyTypes.BackingSpec.Builder(FloppyTypes.BackingType.CLIENT_DEVICE).build()).build();
        List<DeviceTypes.EntryCreateSpec> bootDevices = Arrays.asList(new DeviceTypes.EntryCreateSpec.Builder(DeviceTypes.Type.CDROM).build(), new DeviceTypes.EntryCreateSpec.Builder(DeviceTypes.Type.DISK).build(), new DeviceTypes.EntryCreateSpec.Builder(DeviceTypes.Type.ETHERNET).build());
        VMTypes.CreateSpec vmCreateSpec = new VMTypes.CreateSpec.Builder(this.vmGuestOS).setBootDevices(bootDevices).setCdroms(Collections.singletonList(cdromCreateSpec)).setCpu(cpuUpdateSpec).setDisks(Arrays.asList(diskCreateSpec1, diskCreateSpec2, diskCreateSpec3)).setFloppies(Collections.singletonList(floppyCreateSpec)).setHardwareVersion(this.HARDWARE_VERSION).setMemory(memoryUpdateSpec).setName(EXHAUSTIVE_VM_NAME).setNics(Arrays.asList(manualEthernetSpec, generatedEthernetSpec)).setParallelPorts(Collections.singletonList(parallelCreateSpec)).setPlacement(vmPlacementSpec).setSerialPorts(Collections.singletonList(serialCreateSpec)).build();
        System.out.println("\n\n#### Example: Creating exhaustive VM with spec:\n" + vmCreateSpec);
        this.exhaustiveVMId = this.vmService.create(vmCreateSpec);
        System.out.println("\nCreated exhaustive VM : Sample-Exhaustive-VM with id: " + this.exhaustiveVMId);
        VMTypes.Info vmInfo = this.vmService.get(this.exhaustiveVMId);
        System.out.println("\nExhaustive VM Info:\n" + vmInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Deleting the Exhaustive VM");
        if (this.exhaustiveVMId != null) {
            this.vmService.delete(this.exhaustiveVMId);
        }
    }

    public static void main(String[] args) throws Exception {
        new CreateExhaustiveVM().execute(args);
    }
}

