/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.adapter;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.hardware.adapter.Scsi;
import com.vmware.vcenter.vm.hardware.adapter.ScsiTypes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class ScsiAdapterConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    private List<String> createdScsiAdapters = new ArrayList<String>();
    private Scsi scsiService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().required(true).hasArg().argName("VM NAME").longOpt("vmname").desc("The name of the vm for which to configure virtual SCSI adapter").build();
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add(vmNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
    }

    @Override
    protected void setup() throws Exception {
        this.scsiService = (Scsi)this.vapiAuthHelper.getStubFactory().createStub(Scsi.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for SCSI adapter configuration sample.");
    }

    @Override
    protected void run() throws Exception {
        ScsiTypes.Info scsiInfo;
        System.out.println("\n\n#### Example: List of all SCSI adapters on the VM.");
        List scsiSummaries = this.scsiService.list(this.vmId);
        System.out.println(scsiSummaries);
        System.out.println("\n\n#### Display information about each adapter.");
        for (ScsiTypes.Summary scsiSummary : scsiSummaries) {
            scsiInfo = this.scsiService.get(this.vmId, scsiSummary.getAdapter());
            System.out.println(scsiInfo);
        }
        System.out.println("\n\n#### Example: Create SATA adapter with defaults.");
        ScsiTypes.CreateSpec scsiCreateSpec = new ScsiTypes.CreateSpec();
        String scsiId = this.scsiService.create(this.vmId, scsiCreateSpec);
        System.out.println(scsiCreateSpec);
        scsiInfo = this.scsiService.get(this.vmId, scsiId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("SCSI Adapter ID=" + scsiId);
        System.out.println(scsiInfo);
        this.createdScsiAdapters.add(scsiId);
        System.out.println("\n\n#### Create SCSI adapter with specific bus and sharing=true");
        scsiCreateSpec = new ScsiTypes.CreateSpec.Builder().setBus(Long.valueOf(2L)).setSharing(ScsiTypes.Sharing.VIRTUAL).build();
        scsiId = this.scsiService.create(this.vmId, scsiCreateSpec);
        System.out.println(scsiCreateSpec);
        scsiInfo = this.scsiService.get(this.vmId, scsiId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("SCSI Adapter ID=" + scsiId);
        System.out.println(scsiInfo);
        this.createdScsiAdapters.add(scsiId);
        System.out.println("\n\n#### Update SCSI adapter by setting sharing=false");
        ScsiTypes.UpdateSpec scsiUpdateSpec = new ScsiTypes.UpdateSpec.Builder().setSharing(ScsiTypes.Sharing.NONE).build();
        this.scsiService.update(this.vmId, scsiId, scsiUpdateSpec);
        System.out.println(scsiUpdateSpec);
        scsiInfo = this.scsiService.get(this.vmId, scsiId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("SCSI Adapter ID=" + scsiId);
        System.out.println(scsiInfo);
        System.out.println("\n\n####List of all SCSI adapters on the VM");
        scsiSummaries = this.scsiService.list(this.vmId);
        System.out.println(scsiSummaries);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Cleanup: Deleting all the adapters that were created");
        for (String scsiId : this.createdScsiAdapters) {
            this.scsiService.delete(this.vmId, scsiId);
        }
        System.out.println("\n\n#### List of all SCSI adapters on the VM");
        List scsiSummaries = this.scsiService.list(this.vmId);
        System.out.println(scsiSummaries);
    }

    public static void main(String[] args) throws Exception {
        new ScsiAdapterConfiguration().execute(args);
    }
}

