/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.ethernet;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.Power;
import com.vmware.vcenter.vm.PowerTypes;
import com.vmware.vcenter.vm.hardware.Ethernet;
import com.vmware.vcenter.vm.hardware.EthernetTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.NetworkHelper;
import vmware.samples.vcenter.helpers.VmHelper;

public class EthernetConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String datacenterName;
    private String stdPortgroupName;
    private String distPortgroupName;
    private String vmId;
    private List<String> createdNics = new ArrayList<String>();
    private Power powerService;
    private Ethernet ethernetService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().longOpt("vmname").desc("The name of the vm for which to configure the virtual ethernet adapters.").required(true).hasArg().argName("VM NAME").build();
        Option datacenterOption = Option.builder().longOpt("datacenter").desc("The name of the datacenter containing the vCenter networks").required(true).hasArg().argName("DATACENTER").build();
        Option stdPortgroupOption = Option.builder().longOpt("standardportgroup").desc("The name of the standard portgroup").required(true).hasArg().argName("STANDARD PORTGROUP").build();
        Option distPortgroupOption = Option.builder().longOpt("distributedportgroup").desc("The name of the distributed portgroup").required(true).hasArg().argName("DISTRIBUTED PORTGROUP").build();
        List<Option> optionList = Arrays.asList(vmNameOption, datacenterOption, stdPortgroupOption, distPortgroupOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
        this.datacenterName = (String)this.parsedOptions.get("datacenter");
        this.stdPortgroupName = (String)this.parsedOptions.get("standardportgroup");
        this.distPortgroupName = (String)this.parsedOptions.get("distributedportgroup");
    }

    @Override
    protected void setup() throws Exception {
        this.powerService = (Power)this.vapiAuthHelper.getStubFactory().createStub(Power.class, (StubConfigurationBase)this.sessionStubConfig);
        this.ethernetService = (Ethernet)this.vapiAuthHelper.getStubFactory().createStub(Ethernet.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for ethernet adapter configuration sample.");
    }

    @Override
    protected void run() throws Exception {
        List nicSummaries = this.ethernetService.list(this.vmId);
        System.out.println("\n\n#### List of all Ethernet NICS on the VM:\n" + nicSummaries);
        System.out.println("\n\n####Print info for each Ethernet NIC on the vm.");
        for (EthernetTypes.Summary ethSummary : nicSummaries) {
            EthernetTypes.Info ethInfo = this.ethernetService.get(this.vmId, ethSummary.getNic());
            System.out.println(ethInfo);
        }
        System.out.println("\n\n#### Example: Create Ethernet NIC using STANDARD_PORTGROUP with default settings.");
        String stdNetworkId = NetworkHelper.getStandardNetworkBacking(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.stdPortgroupName);
        EthernetTypes.CreateSpec nicCreateSpec = new EthernetTypes.CreateSpec.Builder().setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.STANDARD_PORTGROUP).setNetwork(stdNetworkId).build()).build();
        String nicId = this.ethernetService.create(this.vmId, nicCreateSpec);
        this.createdNics.add(nicId);
        System.out.println(nicCreateSpec);
        EthernetTypes.Info nicInfo = this.ethernetService.get(this.vmId, nicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + nicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Example: Create Ethernet NIC using DISTRIBUTED_PORTGROUP with default settings.");
        String distNetworkId = NetworkHelper.getDistributedNetworkBacking(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.distPortgroupName);
        nicCreateSpec = new EthernetTypes.CreateSpec.Builder().setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.DISTRIBUTED_PORTGROUP).setNetwork(distNetworkId).build()).build();
        nicId = this.ethernetService.create(this.vmId, nicCreateSpec);
        this.createdNics.add(nicId);
        System.out.println(nicCreateSpec);
        nicInfo = this.ethernetService.get(this.vmId, nicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + nicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Example: Create Ethernet NIC using standard portgroup and specifying start_connected=true, allow_guest_control=true, mac_type, mac_address, wake_on_lan=enabled.");
        nicCreateSpec = new EthernetTypes.CreateSpec.Builder().setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.STANDARD_PORTGROUP).setNetwork(stdNetworkId).build()).setStartConnected(Boolean.valueOf(true)).setAllowGuestControl(Boolean.valueOf(true)).setMacType(EthernetTypes.MacAddressType.MANUAL).setMacAddress("01:23:45:67:89:10").build();
        nicId = this.ethernetService.create(this.vmId, nicCreateSpec);
        this.createdNics.add(nicId);
        System.out.println(nicCreateSpec);
        nicInfo = this.ethernetService.get(this.vmId, nicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + nicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Example: Create Ethernet NIC using distributed portgroup and specifying start_connected=true, allow_guest_control=true, mac_type, mac_address, wake_on_lan=enabled.");
        nicCreateSpec = new EthernetTypes.CreateSpec.Builder().setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.STANDARD_PORTGROUP).setNetwork(stdNetworkId).build()).setStartConnected(Boolean.valueOf(true)).setAllowGuestControl(Boolean.valueOf(true)).setMacType(EthernetTypes.MacAddressType.MANUAL).setMacAddress("24:68:10:12:14:16").build();
        nicId = this.ethernetService.create(this.vmId, nicCreateSpec);
        this.createdNics.add(nicId);
        System.out.println(nicCreateSpec);
        nicInfo = this.ethernetService.get(this.vmId, nicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + nicId);
        System.out.println(nicInfo);
        String lastNicId = nicId;
        System.out.println("\n\n#### Example: Update Ethernet NIC with different backing.");
        EthernetTypes.UpdateSpec nicUpdateSpec = new EthernetTypes.UpdateSpec.Builder().setBacking(new EthernetTypes.BackingSpec.Builder(EthernetTypes.BackingType.STANDARD_PORTGROUP).setNetwork(stdNetworkId).build()).build();
        this.ethernetService.update(this.vmId, lastNicId, nicUpdateSpec);
        System.out.println(nicUpdateSpec);
        nicInfo = this.ethernetService.get(this.vmId, lastNicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + lastNicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Example: Update the Ethernet NIC, wake_on_lan = false, mac_type=GENERATED, startConnected = false, allowGuestControl = false.");
        nicUpdateSpec = new EthernetTypes.UpdateSpec.Builder().setAllowGuestControl(Boolean.valueOf(false)).setStartConnected(Boolean.valueOf(false)).setWakeOnLanEnabled(Boolean.valueOf(false)).build();
        this.ethernetService.update(this.vmId, lastNicId, nicUpdateSpec);
        System.out.println(nicUpdateSpec);
        nicInfo = this.ethernetService.get(this.vmId, lastNicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + lastNicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Powering on VM to run connect/disconnect example.");
        this.powerService.start(this.vmId);
        nicInfo = this.ethernetService.get(this.vmId, lastNicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + lastNicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Example: Connect Ethernet NIC after powering on VM.");
        this.ethernetService.connect(this.vmId, lastNicId);
        nicInfo = this.ethernetService.get(this.vmId, lastNicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + lastNicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Example: Disconnect Ethernet NIC after powering on VM.");
        this.ethernetService.disconnect(this.vmId, lastNicId);
        nicInfo = this.ethernetService.get(this.vmId, lastNicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + lastNicId);
        System.out.println(nicInfo);
        System.out.println("\n\n#### Powering off the VM after connect/disconnect example.");
        this.powerService.stop(this.vmId);
        nicInfo = this.ethernetService.get(this.vmId, lastNicId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("Ethernet NIC ID=" + lastNicId);
        System.out.println(nicInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.powerService.get(this.vmId).getState().equals((Object)PowerTypes.State.POWERED_ON)) {
            System.out.println("Power off the vm");
            this.powerService.stop(this.vmId);
        }
        List nicSummaries = this.ethernetService.list(this.vmId);
        System.out.println("\n\n#### List of all Ethernet NICS on the VM:\n" + nicSummaries);
        System.out.println("\n\n#### Cleanup: Delete all the created Ethernet NICs.");
        for (String nicId : this.createdNics) {
            this.ethernetService.delete(this.vmId, nicId);
        }
        nicSummaries = this.ethernetService.list(this.vmId);
        System.out.println("\n\n#### List of all Ethernet NICS on the VM:\n" + nicSummaries);
    }

    public static void main(String[] args) throws Exception {
        new EthernetConfiguration().execute(args);
    }
}

