/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubCreator;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.ClassLoaderUtil;
import com.vmware.vapi.internal.bindings.Stub;
import java.lang.reflect.Constructor;
import org.apache.commons.lang.Validate;

public final class StubFactory
implements StubCreator {
    private static final String STUB_SUFFIX = "Stub";
    private ApiProvider apiProvider;

    public StubFactory(ApiProvider apiProvider) {
        Validate.notNull((Object)apiProvider);
        this.apiProvider = apiProvider;
    }

    @Override
    public <T extends Service> T createStub(Class<T> vapiIface) {
        return this.createStub(vapiIface, null);
    }

    @Override
    public <T extends Service> T createStub(Class<T> vapiIface, StubConfigurationBase config) {
        if (vapiIface == null) {
            throw new IllegalArgumentException("vapiIface is required");
        }
        if (!vapiIface.isInterface()) {
            throw new IllegalArgumentException("vapiIface must represent Java interface");
        }
        if (config == null) {
            config = new StubConfiguration();
        }
        String implClassName = StubFactory.resolveStubClassName(vapiIface);
        try {
            ClassLoader cl = ClassLoaderUtil.getServiceClassLoader();
            Class<?> implClass = cl.loadClass(implClassName);
            if (!vapiIface.isAssignableFrom(implClass)) {
                throw new RuntimeException("Found stub implementation class which doesn't implement requested interface: " + vapiIface.getName());
            }
            if (!Stub.class.isAssignableFrom(implClass)) {
                throw new RuntimeException("Found stub implementation class which doesn't extend " + Stub.class.getName());
            }
            Constructor<?> ctor = implClass.getConstructor(ApiProvider.class, StubConfigurationBase.class);
            ctor.setAccessible(true);
            return (T)((Service)vapiIface.cast(ctor.newInstance(this.apiProvider, config)));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String resolveStubClassName(Class<?> vapiIface) {
        return vapiIface.getName() + STUB_SUFFIX;
    }
}

