/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ValueVisitor;

public final class BooleanValue
implements DataValue {
    private static final long serialVersionUID = 1L;
    private final boolean value;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    public static BooleanValue getInstance(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public boolean equals(Object o) {
        if (o instanceof BooleanValue) {
            BooleanValue bool = (BooleanValue)o;
            return this.value == bool.value;
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BooleanValue copy() {
        return this;
    }
}

