/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.data.ConstraintValidator;
import org.apache.commons.lang.Validate;

public class HasFieldsOfValidator
implements ConstraintValidator {
    private static final Message FAILED_VALIDATION_MSG = MessageFactory.getMessage("vapi.data.structure.hasfieldsof.invalid", new String[0]);
    private final TypeReference<? extends StructType> structTypeRef;
    private TypeConverter converter;

    public HasFieldsOfValidator(TypeReference<? extends StructType> structTypeRef) {
        Validate.notNull(structTypeRef);
        this.structTypeRef = structTypeRef;
    }

    @Override
    public void validate(DataValue dataValue) {
        if (this.converter == null) {
            this.converter = new TypeConverterImpl(true);
        }
        try {
            this.converter.convertToJava(dataValue, this.structTypeRef.resolve());
        }
        catch (ConverterException e) {
            throw new ConstraintValidationException(FAILED_VALIDATION_MSG, (Throwable)e);
        }
    }
}

