/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.std.Progress;
import org.apache.commons.lang.Validate;

public final class RetryingCallback<T>
extends AsyncCallback<T> {
    private final AsyncCallback<T> decoratedCallback;
    private final RetryPolicy retryPolicy;
    private final RetryPolicy.RetryContext retryContext;
    private final int invocationAttempt;
    private final Retryable retryable;

    public RetryingCallback(AsyncCallback<T> decoratedCallback, RetryPolicy retryPolicy, RetryPolicy.RetryContext retryContext, int invocationAttempt, Retryable retryable) {
        Validate.notNull(decoratedCallback);
        Validate.notNull((Object)retryPolicy);
        Validate.notNull((Object)retryContext);
        Validate.isTrue((invocationAttempt >= 0 ? 1 : 0) != 0);
        Validate.notNull((Object)retryable);
        this.decoratedCallback = decoratedCallback;
        this.retryPolicy = retryPolicy;
        this.retryContext = retryContext;
        this.invocationAttempt = invocationAttempt;
        this.retryable = retryable;
    }

    @Override
    public void onProgress(Progress progress) {
        this.decoratedCallback.onProgress(progress);
    }

    @Override
    public void onResult(T result) {
        this.decoratedCallback.onResult(result);
    }

    @Override
    public void onError(RuntimeException error) {
        RetryPolicy.RetrySpec retrySpec = this.retryPolicy.onInvocationError(error, this.retryContext, this.invocationAttempt);
        if (retrySpec == null) {
            this.decoratedCallback.onError(error);
        } else {
            this.retryable.retry(retrySpec);
        }
    }

    public static interface Retryable {
        public void retry(RetryPolicy.RetrySpec var1);
    }
}

