/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import java.lang.reflect.Method;

public class ApiEnumerationEnumConverter
implements UniTypeConverter<StringValue, EnumType> {
    @Override
    public Object fromValue(StringValue value, EnumType declaredType, TypeConverter typeConverter) {
        Class<ApiEnumeration<?>> enumClass = this.verifyBindingClass(declaredType.getBindingClass());
        try {
            Method valueOf = enumClass.getDeclaredMethod("valueOf", String.class);
            Object obj = valueOf.invoke(null, value.getValue());
            return enumClass.cast(obj);
        }
        catch (Exception ex) {
            throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.enum.valueof.error", enumClass.getCanonicalName(), value.getValue()), (Throwable)ex);
        }
    }

    @Override
    public DataValue toValue(Object binding, EnumType declaredType, TypeConverter typeConverter) {
        Class<? extends ApiEnumeration<?>> enumClass = this.verifyBindingClass(declaredType.getBindingClass());
        ApiEnumeration<?> e = ConvertUtil.narrowType(binding, enumClass);
        return typeConverter.convertToVapi(e.name(), new StringType());
    }

    private Class<? extends ApiEnumeration<?>> verifyBindingClass(Class<?> c) {
        if (ApiEnumeration.class.isAssignableFrom(c)) {
            return c;
        }
        throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.enum.invalid.binding.class", c.getCanonicalName()));
    }
}

