/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaClassStructConverter<V extends StructValue, T extends StructType>
implements UniTypeConverter<V, T> {
    private static final Logger logger = LoggerFactory.getLogger(JavaClassStructConverter.class);
    private final Class<V> valueClass;
    private final Class<? extends Structure> typeClass;
    private final boolean skipUnsetOptionalFields;

    public JavaClassStructConverter(Class<V> valueClass, Class<? extends Structure> typeClass, boolean skipUnsetOptionalFields) {
        Validate.notNull(valueClass);
        Validate.notNull(typeClass);
        this.valueClass = valueClass;
        this.typeClass = typeClass;
        this.skipUnsetOptionalFields = skipUnsetOptionalFields;
    }

    public JavaClassStructConverter(Class<V> valueClass, Class<? extends Structure> typeClass) {
        this(valueClass, typeClass, false);
    }

    @Override
    public Object fromValue(V value, T declaredType, TypeConverter typeConverter) {
        StaticStructure struct = this.createStructBinding((StructType)declaredType, (StructValue)value);
        for (String fieldName : ((StructType)declaredType).getFieldNames()) {
            Type fieldType = ((StructType)declaredType).getField(fieldName);
            DataValue fieldValue = null;
            if (((StructValue)value).hasField(fieldName)) {
                fieldValue = ((StructValue)value).getField(fieldName);
            }
            try {
                Object fieldObj = typeConverter.convertToJava(fieldValue, fieldType);
                BindingsUtil.setStructureFieldValue(struct, declaredType, fieldName, fieldObj);
            }
            catch (RuntimeException ex) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.fromvalue.struct.field.error", fieldName, ((StructType)declaredType).getName()), (Throwable)ex);
            }
        }
        return struct;
    }

    @Override
    public DataValue toValue(Object binding, T declaredType, TypeConverter typeConverter) {
        StaticStructure struct = ConvertUtil.narrowType(binding, StaticStructure.class);
        this.checkStructBinding((StructType)declaredType, struct);
        V result = this.createStructInstance(((StructType)declaredType).getName());
        for (String fieldName : ((StructType)declaredType).getFieldNames()) {
            Object fieldBinding = BindingsUtil.getStructureFieldValue(struct, declaredType, fieldName);
            Type fieldType = ((StructType)declaredType).getField(fieldName);
            if (fieldBinding == null) {
                if (!(fieldType instanceof OptionalType)) {
                    throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.tovalue.struct.field.missing", fieldName, ((StructType)declaredType).getName()));
                }
                if (this.skipUnsetOptionalFields) continue;
            }
            try {
                DataValue dataValue = typeConverter.convertToVapi(fieldBinding, fieldType);
                ((StructValue)result).setField(fieldName, dataValue);
            }
            catch (RuntimeException ex) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.typeconverter.tovalue.struct.field.error", fieldName, ((StructType)declaredType).getName()), (Throwable)ex);
            }
        }
        if ("static".equals(System.getProperty("com.vmware.vapi.bindings.SerializationPolicy"))) {
            return result;
        }
        for (String fieldName : struct._getDynamicFieldNames()) {
            DataValue dataValue = struct._getDynamicField(fieldName);
            ((StructValue)result).setField(fieldName, dataValue);
        }
        return result;
    }

    private StructValue extractDynamicFields(StructType structType, StructValue value) {
        V dynamicFieldsStructValue = this.createStructInstance(value.getName());
        Set<String> staticFields = structType.getFieldNames();
        for (String fieldName : value.getFieldNames()) {
            if (staticFields.contains(fieldName)) continue;
            ((StructValue)dynamicFieldsStructValue).setField(fieldName, value.getField(fieldName));
        }
        return dynamicFieldsStructValue;
    }

    private StaticStructure createStructBinding(StructType structType, StructValue value) {
        Class<Structure> structClass = this.getStructClass(structType);
        try {
            Method ctor = structClass.getMethod("_newInstance", StructValue.class);
            return (StaticStructure)ctor.invoke(null, this.extractDynamicFields(structType, value));
        }
        catch (Exception ex) {
            Message message = MessageFactory.getMessage("vapi.bindings.structbinding.struct.ctor.error", structType.getName(), structClass.getCanonicalName());
            logger.error(message.toString());
            throw new ConverterException(message, (Throwable)ex);
        }
    }

    private void checkStructBinding(StructType structType, Structure struct) {
        Class<Structure> expectedClass = this.getStructClass(structType);
        if (!expectedClass.isInstance(struct)) {
            throw new ConverterException("vapi.bindings.structbinding.unexpected.binding.class", expectedClass.getCanonicalName(), structType.getName(), struct.getClass().getCanonicalName());
        }
    }

    private Class<? extends Structure> getStructClass(StructType structType) {
        if (!this.typeClass.isAssignableFrom(structType.getBindingClass())) {
            Message message = MessageFactory.getMessage("vapi.bindings.structbinding.inconsistent.type.info", structType.getBindingClass().getCanonicalName());
            logger.error(message.toString());
            throw new ConverterException(message);
        }
        Class<?> structClass = structType.getBindingClass();
        return structClass;
    }

    private V createStructInstance(String name) {
        try {
            return (V)((StructValue)this.valueClass.getConstructor(String.class).newInstance(name));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

