/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.client;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubCreator;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.bindings.annotation.PackageOf;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.client.Configuration;
import com.vmware.vapi.internal.client.Protocol;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.apache.http.impl.client.CloseableHttpClient;

public final class ApiClient
implements Closeable {
    private final Map<ApiTarget, ApiProvider> restApiProviders;
    private final Configuration config;
    private CloseableHttpClient bioHttpClient;

    public ApiClient() {
        this(Configuration.newEmptyConfig());
    }

    public ApiClient(Configuration config) {
        Validate.notNull((Object)config);
        this.config = config;
        this.restApiProviders = new ConcurrentHashMap<ApiTarget, ApiProvider>();
        this.prepareSharedTrasnport(config);
    }

    public <T extends Service> T createStub(String url, Protocol protocol, Class<T> vapiIface) {
        return this.createStub(url, protocol, vapiIface, null);
    }

    public <T extends Service> T createStub(String url, Protocol protocol, Class<T> vapiIface, StubConfigurationBase config) {
        return this.getStubFactory(url, protocol).createStub(vapiIface, config);
    }

    public StubCreator getStubFactory(String url, Protocol protocol) {
        return new DelayedProtocolStubFactory(url, protocol);
    }

    @Override
    public void close() throws IOException {
        if (this.bioHttpClient != null) {
            this.bioHttpClient.close();
        }
    }

    final void prepareSharedTrasnport(Configuration config) {
        HttpConfiguration httpConfig = config.getProperty("http.client.config", HttpConfiguration.class);
        if (httpConfig == null) {
            httpConfig = new HttpConfiguration.Builder().getConfig();
        }
        switch (httpConfig.getLibraryType()) {
            case APACHE_HTTP_ASYNC_CLIENT: {
                throw new RuntimeException();
            }
            case APACHE_HTTP_CLIENT: {
                this.bioHttpClient = new ApacheBioHttpClientBuilder().buildAndConfigure(httpConfig);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    synchronized ApiProvider findRestApiProvider(String url, Protocol protocol, String component) {
        ApiTarget key = new ApiTarget(url, protocol.isComponentAware() ? component : null);
        ApiProvider result = this.restApiProviders.get(key);
        if (result != null) {
            return result;
        }
        Configuration.Builder enhancedConfig = new Configuration.Builder(this.config);
        enhancedConfig.register("vapi.component", component);
        if (this.bioHttpClient != null) {
            enhancedConfig.register("apache.bio.http.client", this.bioHttpClient);
        }
        result = protocol.getProtocolConnection(url, enhancedConfig.build()).getApiProvider();
        this.restApiProviders.put(key, result);
        return result;
    }

    String resolveComponentName(Class<? extends Service> vapiIface) {
        Package pack = vapiIface.getPackage();
        if (pack == null) {
            throw new RuntimeException("vapiIface doesn't have a package");
        }
        PackageOf packageOf = pack.getAnnotation(PackageOf.class);
        if (packageOf == null) {
            throw new RuntimeException();
        }
        return packageOf.value();
    }

    final class DelayedProtocolStubFactory
    implements StubCreator {
        final String url;
        final Protocol protocol;

        DelayedProtocolStubFactory(String url, Protocol protocol) {
            this.url = url;
            this.protocol = protocol;
        }

        @Override
        public <T extends Service> T createStub(Class<T> vapiIface) {
            return this.createStub(vapiIface, null);
        }

        @Override
        public <T extends Service> T createStub(Class<T> vapiIface, StubConfigurationBase config) {
            return new StubFactory(ApiClient.this.findRestApiProvider(this.url, this.protocol, ApiClient.this.resolveComponentName(vapiIface))).createStub(vapiIface, config);
        }
    }

    static final class ApiTarget {
        private String url;
        private String vapiComponent;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.url.hashCode();
            result = 31 * result + (this.vapiComponent == null ? 0 : this.vapiComponent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApiTarget other = (ApiTarget)obj;
            if (!this.url.equals(other.url)) {
                return false;
            }
            return !(this.vapiComponent == null ? other.vapiComponent != null : !this.vapiComponent.equals(other.vapiComponent));
        }

        ApiTarget(String url, String vapiComponent) {
            Validate.notNull((Object)url);
            this.url = url;
            this.vapiComponent = vapiComponent;
        }

        String getUrl() {
            return this.url;
        }

        String getComponent() {
            return this.vapiComponent;
        }
    }
}

