/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.core.abort;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class AbortHandleImpl
implements AbortHandle {
    private boolean isAborted = false;
    private final List<AbortListener> listeners = new ArrayList<AbortListener>();

    @Override
    public synchronized void addAbortListener(AbortListener listener) {
        Validate.notNull((Object)listener);
        if (this.isAborted()) {
            return;
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        AbortHandleImpl abortHandleImpl = this;
        synchronized (abortHandleImpl) {
            if (this.isAborted) {
                return;
            }
            this.isAborted = true;
        }
        for (AbortListener listener : this.listeners) {
            listener.onAbort();
        }
    }

    @Override
    public synchronized boolean isAborted() {
        return this.isAborted;
    }
}

