/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructRefDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ReferenceResolver {
    private final Map<String, StructDefinition> definitions = new HashMap<String, StructDefinition>();
    private final List<StructRefDefinition> references = new ArrayList<StructRefDefinition>();

    public void addDefinition(StructDefinition structDef) {
        Validate.notNull((Object)structDef);
        this.definitions.put(structDef.getName(), structDef);
    }

    public void addReference(StructRefDefinition structRefDef) {
        Validate.notNull((Object)structRefDef);
        this.references.add(structRefDef);
    }

    public boolean isDefined(String structName) {
        Validate.notNull((Object)structName);
        return this.definitions.containsKey(structName);
    }

    public void resolveReferences() {
        for (StructRefDefinition ref : this.references) {
            if (ref.getTarget() != null) continue;
            StructDefinition def = this.definitions.get(ref.getName());
            if (def == null) {
                throw new CoreException(MessageFactory.getMessage("vapi.data.structref.structure.not.defined", ref.getName()));
            }
            ref.setTarget(def);
        }
    }

    public StructDefinition getDefinition(String structName) {
        Validate.notNull((Object)structName);
        return this.definitions.get(structName);
    }
}

