/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.InputStreamBinaryInput;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
implements CorrelatingClient {
    private static Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private final String uri;
    private final CloseableHttpClient httpClient;
    private Thread connectionMonitor;

    public HttpClient(String uri) {
        this(uri, new HttpConfiguration.Builder().getConfig());
    }

    public HttpClient(String uri, HttpConfiguration httpConfig) {
        Validate.notNull((Object)uri);
        Validate.notNull((Object)httpConfig);
        this.uri = uri;
        this.httpClient = this.createDefaultHttpClient(httpConfig);
    }

    public HttpClient(String uri, CloseableHttpClient httpClient) {
        Validate.notNull((Object)uri);
        Validate.notNull((Object)httpClient);
        this.uri = uri;
        this.httpClient = httpClient;
    }

    private CloseableHttpClient createDefaultHttpClient(HttpConfiguration httpConfig) {
        assert (httpConfig != null);
        try {
            new URL(this.uri);
        }
        catch (MalformedURLException ex) {
            logger.error("Exception while trying to parse URL", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        ApacheBioHttpClientBuilder httpClientBuilder = new ApacheBioHttpClientBuilder();
        CloseableHttpClient result = httpClientBuilder.buildAndConfigure(httpConfig);
        this.connectionMonitor = httpClientBuilder.buildConnectionMonitorThread(logger);
        this.connectionMonitor.start();
        return result;
    }

    private HttpEntity invoke(InputStream request, int requestLength, AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb) throws IOException {
        String requestContentType = "application/json";
        HttpPost post = new HttpPost(this.uri);
        post.setEntity((HttpEntity)new InputStreamEntity(request, (long)requestLength));
        post.setHeader("Content-Type", requestContentType);
        post.setHeader("Accept", "application/vnd.vmware.vapi.framed," + requestContentType);
        logger.debug("Value of uri is:" + this.uri);
        if (Util.checkRequestAborted(abortHandle, cb)) {
            return null;
        }
        Util.registerAbortListerner(cb, post, abortHandle);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
        ApacheHttpUtil.validateHttpResponse((HttpResponse)response, requestContentType);
        return response.getEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(InputStream request, int requestLength, AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb) {
        Validate.notNull((Object)request);
        Validate.isTrue((requestLength >= -1 ? 1 : 0) != 0);
        Validate.notNull((Object)cb);
        if (Util.checkRequestAborted(abortHandle, cb)) {
            return;
        }
        try {
            HttpEntity httpResponse = this.invoke(request, requestLength, abortHandle, cb);
            if (httpResponse == null) {
                return;
            }
            String contentType = null;
            if (httpResponse.getContentType() != null) {
                contentType = httpResponse.getContentType().getValue();
            }
            InputStream inp = httpResponse.getContent();
            try {
                this.handleContent(contentType, inp, cb);
            }
            finally {
                IoUtil.silentClose(inp);
            }
        }
        catch (Exception ex) {
            cb.failed(ApacheHttpClientExceptionTranslator.translate(ex, abortHandle));
        }
    }

    private void handleContent(String contentType, InputStream content, CorrelatingClient.ResponseCallback cb) throws IOException {
        if (contentType != null && contentType.startsWith("application/vnd.vmware.vapi.framed")) {
            byte[] frame;
            ChunkedTransferEncodingFrameDeserializer frameDeserializer = new ChunkedTransferEncodingFrameDeserializer();
            InputStreamBinaryInput input = new InputStreamBinaryInput(content);
            while ((frame = frameDeserializer.readFrame(input)) != null) {
                cb.received(new ByteArrayInputStream(frame));
            }
        } else {
            byte[] frame = IoUtil.readAll(content);
            cb.received(new ByteArrayInputStream(frame));
        }
    }

    @Override
    public void close() {
        if (this.connectionMonitor != null) {
            this.connectionMonitor.interrupt();
        }
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.warn("Exception while trying to close the HttpClient", (Throwable)e);
        }
    }
}

