/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.http.impl;

import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.lang.Validate;

public final class FixedLengthFieldDeserializer {
    private final int capacity;
    private final byte[] data;
    private int currentSize;
    private boolean done;

    public FixedLengthFieldDeserializer(int length) {
        Validate.isTrue((length >= 0 ? 1 : 0) != 0);
        this.capacity = length;
        this.data = new byte[this.capacity];
        this.currentSize = 0;
        this.done = false;
    }

    public byte[] read(BinaryInput input) throws IOException {
        if (this.done) {
            throw new IllegalStateException("Field already extracted. The deserializer can be used only for a single field.");
        }
        int remaining;
        int off;
        int readCount;
        while ((readCount = input.read(this.data, off = this.currentSize, remaining = this.capacity - this.currentSize)) != -2) {
            if (readCount == -1) {
                throw new EOFException();
            }
            if (readCount == remaining) {
                this.done = true;
                return this.data;
            }
            this.currentSize += readCount;
        }
        return null;
    }
}

