/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.diagnostics.DiagnosticsKey;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonConstants;
import com.vmware.vapi.internal.protocol.common.json.JsonDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodParamsException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.protocol.common.json.JsonProgressResponse;
import com.vmware.vapi.internal.security.SecurityUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang.time.StopWatch;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class JsonMsgDeserializer2
implements JsonDeserializer {
    private static final String OUTPUT = "output";
    private static final String ERROR = "error";
    private static final String PROGRESS = "progress";
    private static final String RPC_VERSION = "2.0";
    private static final String MSG_RESPONSE_DESERIALIZER_TIME = "msgResponseDeserializerTimer2";
    private static final String MSG_REQUEST_DESERIALIZER_TIME = "msgRequestDeserializerTimer2";
    private static final String INVALID_TYPE_IN_SECURITY_CONTEXT_MSG = "Found invalid type in the security context";
    private final JsonFactory factory = new JsonFactory();

    public JsonMsgDeserializer2() {
        DiagnosticsKey key = new DiagnosticsKey("JsonMsgDeserializer2", new String[]{MSG_REQUEST_DESERIALIZER_TIME, MSG_RESPONSE_DESERIALIZER_TIME});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonBaseRequest requestDeserialize(String jsonRequest) throws JsonInvalidMethodParamsException, JsonInvalidRequest, JsonInvalidDataValueException, JsonInvalidMethodException, JsonParseException, IOException {
        StopWatch msgRequestDeserializerTimer = new StopWatch();
        msgRequestDeserializerTimer.start();
        try {
            JsonToken nextToken;
            String rpcVersion = null;
            String id = null;
            String jsonMethod = null;
            JsonInvokeRequestParams2 jirp = null;
            JsonParser jp = this.factory.createJsonParser(jsonRequest);
            jp.nextToken();
            while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT && nextToken != null) {
                JsonToken token = jp.getCurrentToken();
                if (token != JsonToken.FIELD_NAME) {
                    throw new JsonInvalidRequest(String.format("Received unexpected json token %s", token), id);
                }
                String jsonNode = jp.getCurrentName();
                if (jsonNode.equals("jsonrpc")) {
                    jp.nextToken();
                    rpcVersion = jp.getText();
                    if (rpcVersion.equals(RPC_VERSION)) continue;
                    throw new JsonInvalidRequest(String.format("Received Invalid rpc version %s", rpcVersion), id);
                }
                if (jsonNode.equals("id")) {
                    jp.nextToken();
                    id = jp.getText();
                    continue;
                }
                if (jsonNode.equals("method")) {
                    jp.nextToken();
                    jsonMethod = jp.getText();
                    if (JsonConstants.RequestType.invoke.toString().equals(jsonMethod)) continue;
                    throw new JsonInvalidMethodException(id, jsonMethod, "Invalid method:" + jsonMethod);
                }
                if (jp.getText().equals("params")) {
                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.FIELD_NAME);
                    ExecutionContext ctx = null;
                    String serviceId = null;
                    String operationId = null;
                    DataValue dv = null;
                    while ((token = jp.getCurrentToken()) != JsonToken.END_OBJECT) {
                        if (token != JsonToken.FIELD_NAME) {
                            throw new JsonInvalidRequest(String.format("Received unexpected json token %s", token), id);
                        }
                        String fieldName = jp.getCurrentName();
                        if ("ctx".equals(fieldName)) {
                            jp.nextToken();
                            ctx = JsonMsgDeserializer2.deserializeExCtx(jp, id);
                            jp.nextToken();
                            continue;
                        }
                        if ("serviceId".equals(fieldName)) {
                            jp.nextToken();
                            serviceId = jp.getText();
                            jp.nextToken();
                            continue;
                        }
                        if ("operationId".equals(fieldName)) {
                            jp.nextToken();
                            operationId = jp.getText();
                            jp.nextToken();
                            continue;
                        }
                        if ("input".equals(fieldName)) {
                            jp.nextToken();
                            dv = JsonMsgDeserializer2.deserializeDataValue(jp);
                            continue;
                        }
                        throw new JsonInvalidRequest(String.format("Unexpected field in '%s' value: %s", "params", fieldName), id);
                    }
                    JsonMsgDeserializer2.verifyFieldProcessed("serviceId", serviceId, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("operationId", operationId, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("ctx", ctx, id);
                    JsonMsgDeserializer2.verifyFieldProcessed("input", dv, id);
                    jirp = new JsonInvokeRequestParams2(serviceId, operationId, ctx, dv);
                    continue;
                }
                throw new JsonInvalidRequest(String.format("Received unexpected jsonNode %s", jsonNode), id);
            }
            JsonMsgDeserializer2.verifyFieldProcessed("jsonrpc", rpcVersion, id);
            JsonMsgDeserializer2.verifyFieldProcessed("id", id, id);
            JsonMsgDeserializer2.verifyFieldProcessed("method", jsonMethod, id);
            JsonMsgDeserializer2.verifyFieldProcessed("params", jirp, id);
            JsonApiRequest jsonApiRequest = new JsonApiRequest(id, jirp);
            return jsonApiRequest;
        }
        finally {
            msgRequestDeserializerTimer.stop();
        }
    }

    @Override
    public JsonBaseResponse responseDeserialize(InputStream jsonResponse, JsonConstants.RequestType responseType) {
        try {
            JsonToken nextToken;
            String rpcVersion = null;
            String id = null;
            DataValue output = null;
            ErrorValue error = null;
            JsonParser jp = this.factory.createJsonParser(jsonResponse);
            jp.nextToken();
            while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT && nextToken != null) {
                JsonToken token = jp.getCurrentToken();
                if (token != JsonToken.FIELD_NAME) {
                    throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received unexpected json token %s", token)));
                }
                String jsonNode = jp.getCurrentName();
                if ("jsonrpc".equals(jsonNode)) {
                    jp.nextToken();
                    rpcVersion = jp.getText();
                    if (RPC_VERSION.equals(rpcVersion)) continue;
                    throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received Invalid rpc version %s", rpcVersion)));
                }
                if ("id".equals(jsonNode)) {
                    jp.nextToken();
                    id = jp.getText();
                    continue;
                }
                if ("result".equals(jsonNode)) {
                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
                    JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.FIELD_NAME);
                    String fieldName = jp.getCurrentName();
                    if (OUTPUT.equals(fieldName)) {
                        jp.nextToken();
                        output = JsonMsgDeserializer2.deserializeDataValue(jp);
                        continue;
                    }
                    if (ERROR.equals(fieldName)) {
                        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
                        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.FIELD_NAME);
                        error = JsonMsgDeserializer2.deserializeErrorValue(jp);
                        continue;
                    }
                    if (!PROGRESS.equals(fieldName)) continue;
                    jp.nextToken();
                    return new JsonProgressResponse(id, JsonMsgDeserializer2.deserializeDataValue(jp));
                }
                if (ERROR.equals(jsonNode)) {
                    String jsonErrorCode = null;
                    String jsonErrorMessage = null;
                    String jsonErrorData = null;
                    jp.nextToken();
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                            throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received unexpected json token %s", jp.getCurrentToken())));
                        }
                        if ("code".equals(jp.getCurrentName())) {
                            jp.nextToken();
                            jsonErrorCode = jp.getText();
                            continue;
                        }
                        if ("message".equals(jp.getCurrentName())) {
                            jp.nextToken();
                            jsonErrorMessage = jp.getText();
                            continue;
                        }
                        if (!"data".equals(jp.getCurrentName())) continue;
                        jp.nextToken();
                        jsonErrorData = jp.getText();
                    }
                    String errorMessage = "Recieved JSON-RPC 2.0 error with code:" + jsonErrorCode + " and message:" + jsonErrorMessage;
                    throw new JsonInvalidResponse(errorMessage, jsonErrorCode, jsonErrorData);
                }
                throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse(String.format("Received unexpected jsonNode %s", jsonNode)));
            }
            JsonMsgDeserializer2.verifyFieldProcessed("jsonrpc", rpcVersion, id);
            JsonMsgDeserializer2.verifyFieldProcessed("id", id, id);
            if (output != null && error != null) {
                throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse("Received both Result and Error values"));
            }
            if (output == null && error == null) {
                throw JsonMsgDeserializer2.toVapiCoreException(new JsonInvalidResponse("Both Result and Error Values are missing"));
            }
            if (output != null) {
                return new JsonApiResponse(id, MethodResult.newResult(output));
            }
            return new JsonApiResponse(id, MethodResult.newErrorResult(error));
        }
        catch (JsonInvalidResponse e) {
            throw JsonMsgDeserializer2.toVapiCoreException(e);
        }
        catch (JsonParseException e) {
            throw JsonMsgDeserializer2.toVapiCoreException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw JsonMsgDeserializer2.toVapiCoreException(e);
        }
    }

    private static ExecutionContext deserializeExCtx(JsonParser jp, String id) throws JsonParseException, JsonInvalidMethodParamsException, IOException {
        ExecutionContext exCtx = null;
        HashMap<String, String> map = new HashMap<String, String>();
        ExecutionContext.SecurityContext sc = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            if (fieldName.equals("appCtx")) {
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String key = jp.getText();
                    jp.nextToken();
                    String value = jp.getText();
                    map.put(key, value);
                }
                continue;
            }
            if (!fieldName.equals("securityCtx")) continue;
            jp.nextToken();
            sc = JsonMsgDeserializer2.deserializeSecurityContext(jp, id);
        }
        exCtx = new ExecutionContext(new ExecutionContext.ApplicationData(map), sc);
        return exCtx;
    }

    private static ExecutionContext.SecurityContext deserializeSecurityContext(JsonParser jp, String id) throws JsonParseException, JsonInvalidMethodParamsException, IOException {
        HashMap<String, Object> secCtxData = new HashMap<String, Object>();
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken != JsonToken.START_OBJECT) {
            return null;
        }
        jp.nextToken();
        while (currentToken != JsonToken.END_OBJECT) {
            String key = jp.getText();
            jp.nextToken();
            Object value = JsonMsgDeserializer2.parseJsonObject(jp);
            secCtxData.put(key, value);
            currentToken = jp.getCurrentToken();
        }
        Object schemeId = secCtxData.get("schemeId");
        if (schemeId == null || schemeId.getClass() != String.class) {
            throw new JsonInvalidMethodParamsException(id, "Missing or invalid value type for 'schemeId'");
        }
        secCtxData.put("authn_scheme_id", schemeId);
        return SecurityUtil.createDefaultSecurityContext(secCtxData);
    }

    private static Object parseJsonObject(JsonParser jp) throws JsonParseException, IOException {
        Object value = null;
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            value = jp.getText();
        } else if (curr == JsonToken.START_OBJECT) {
            jp.nextToken();
            HashMap<String, Object> data = new HashMap<String, Object>();
            while (curr != JsonToken.END_OBJECT) {
                String key = jp.getText();
                jp.nextToken();
                Object val = JsonMsgDeserializer2.parseJsonObject(jp);
                data.put(key, val);
                curr = jp.getCurrentToken();
            }
            value = data;
        } else {
            throw JsonMsgDeserializer2.toVapiCoreException(new RuntimeException(INVALID_TYPE_IN_SECURITY_CONTEXT_MSG));
        }
        jp.nextToken();
        return value;
    }

    static StructValue deserializeStructValue(JsonParser jp) throws JsonParseException, IOException {
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.FIELD_NAME);
        StructValue sv = new StructValue(jp.getCurrentName());
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            sv.setField(fieldName, JsonMsgDeserializer2.deserializeDataValue(jp));
        }
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return sv;
    }

    static ListValue deserializeListValue(JsonParser jp) throws JsonParseException, IOException {
        ListValue lv = new ListValue();
        jp.nextToken();
        while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT || jp.getCurrentToken() == JsonToken.START_ARRAY) {
                lv.add(JsonMsgDeserializer2.deserializeDataValue(jp));
                continue;
            }
            lv.add(JsonMsgDeserializer2.deserializePrimitiveValue(jp));
        }
        jp.nextToken();
        return lv;
    }

    static DataValue deserializePrimitiveValue(JsonParser jp) throws JsonParseException, IOException {
        try {
            BooleanValue dv = null;
            dv = jp.getBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
            jp.nextToken();
            return dv;
        }
        catch (JsonParseException jpEx) {
            if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                jp.nextValue();
            }
            JsonToken curr = jp.getCurrentToken();
            DataValue dv = null;
            dv = curr == JsonToken.VALUE_NUMBER_INT ? new IntegerValue(jp.getLongValue()) : (curr == JsonToken.VALUE_NUMBER_FLOAT ? new DoubleValue(jp.getDoubleValue()) : (curr == JsonToken.VALUE_NULL ? VoidValue.getInstance() : new StringValue(jp.getText())));
            jp.nextToken();
            return dv;
        }
    }

    static OptionalValue deserializeOptionalValue(JsonParser jp) throws JsonParseException, IOException {
        if (jp.nextToken() == JsonToken.VALUE_NULL) {
            JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.END_OBJECT);
            jp.nextToken();
            return new OptionalValue();
        }
        OptionalValue result = new OptionalValue(JsonMsgDeserializer2.deserializeDataValue(jp));
        jp.nextToken();
        return result;
    }

    static SecretValue deserializeSecretValue(JsonParser jp) throws JsonParseException, IOException {
        jp.nextToken();
        String text = jp.getText();
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return new SecretValue(text.toCharArray());
    }

    static BlobValue deserializeBinaryValue(JsonParser jp) throws JsonParseException, IOException {
        jp.nextToken();
        byte[] bytes = jp.getBinaryValue();
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return new BlobValue(bytes);
    }

    static ErrorValue deserializeErrorValue(JsonParser jp) throws JsonParseException, IOException {
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.FIELD_NAME);
        ErrorValue val = new ErrorValue(jp.getText());
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.START_OBJECT);
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            val.setField(fieldName, JsonMsgDeserializer2.deserializeDataValue(jp));
        }
        JsonMsgDeserializer2.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return val;
    }

    static DataValue deserializeDataValue(JsonParser jp) throws JsonParseException, IOException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return JsonMsgDeserializer2.deserializeListValue(jp);
        }
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            jp.nextToken();
        }
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            String dataType = jp.getCurrentName();
            if (dataType.equals(DataType.STRUCTURE.getValue())) {
                return JsonMsgDeserializer2.deserializeStructValue(jp);
            }
            if (dataType.equals(DataType.OPTIONAL.getValue())) {
                return JsonMsgDeserializer2.deserializeOptionalValue(jp);
            }
            if (dataType.equals(DataType.SECRET.getValue())) {
                return JsonMsgDeserializer2.deserializeSecretValue(jp);
            }
            if (dataType.equals(DataType.BLOB.getValue())) {
                return JsonMsgDeserializer2.deserializeBinaryValue(jp);
            }
            if (dataType.equals(DataType.ERROR.getValue())) {
                return JsonMsgDeserializer2.deserializeErrorValue(jp);
            }
            throw new JsonInvalidDataValueException("Unexpected JSON field detected: " + dataType);
        }
        return JsonMsgDeserializer2.deserializePrimitiveValue(jp);
    }

    static void nextExpectedToken(JsonParser jp, JsonToken expected) throws JsonParseException, IOException {
        if (jp.nextToken() != expected) {
            throw new JsonInvalidDataValueException(String.format("Expected %s JSON token but detected %s", expected, jp.getCurrentToken()));
        }
    }

    private static void verifyFieldProcessed(String fieldName, Object value, String id) throws JsonInvalidMethodParamsException {
        if (value == null) {
            throw new JsonInvalidMethodParamsException(id, "Missing node: " + fieldName);
        }
    }

    private static CoreException toVapiCoreException(Exception ex) {
        return new CoreException(MessageFactory.getMessage("vapi.json.deserialize.ioerror", ex.getMessage()), (Throwable)ex);
    }
}

