/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.async;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.data.DataValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SetAccumulator<T> {
    private final AsyncHandle<Set<T>> asyncHandle;
    private final int total;
    private int received;
    private final Set<T> accumulator;

    public SetAccumulator(AsyncHandle<Set<T>> asyncHandle, int total) {
        this.asyncHandle = asyncHandle;
        this.total = total;
        this.received = 0;
        this.accumulator = new HashSet<T>();
        if (total == 0) {
            asyncHandle.setResult(this.accumulator);
        }
    }

    public AsyncHandle<Set<T>> createSlave() {
        return new AsyncHandle<Set<T>>(){

            @Override
            public void updateProgress(DataValue progress) {
            }

            @Override
            public void setResult(Set<T> result) {
                SetAccumulator.this.onResult(result);
            }

            @Override
            public void setError(RuntimeException error) {
                SetAccumulator.this.onError(error);
            }
        };
    }

    public AsyncHandle<T> createSlaveForOneElement() {
        return new AsyncHandle<T>(){

            @Override
            public void updateProgress(DataValue progress) {
            }

            @Override
            public void setResult(T result) {
                Set s = result != null ? Collections.singleton(result) : Collections.emptySet();
                SetAccumulator.this.onResult(s);
            }

            @Override
            public void setError(RuntimeException error) {
                SetAccumulator.this.onError(error);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResult(Set<T> value) {
        Set<T> set = this.accumulator;
        synchronized (set) {
            if (this.received >= this.total) {
                return;
            }
            this.accumulator.addAll(value);
            this.subsidiaryOperationCompleted();
        }
    }

    private void onError(RuntimeException error) {
        this.subsidiaryOperationCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subsidiaryOperationCompleted() {
        Set<T> set = this.accumulator;
        synchronized (set) {
            ++this.received;
            if (this.received >= this.total) {
                this.asyncHandle.setResult(this.accumulator);
            }
        }
    }
}

