/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.l10n;

import com.vmware.vapi.l10n.LocalizationException;
import com.vmware.vapi.l10n.MessageArgConverter;
import com.vmware.vapi.l10n.TemplateFormatter;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.Validate;

public class MessageFormatTemplateFormatter
implements TemplateFormatter {
    private MessageArgConverter argConverter = new MessageArgConverter();

    @Override
    public String format(String msgTemplate, List<String> args, Locale locale) {
        Validate.notNull((Object)msgTemplate);
        Validate.notNull(args);
        Validate.notNull((Object)locale);
        MessageFormat msgFormat = null;
        try {
            msgFormat = new MessageFormat(msgTemplate, locale);
            StringBuffer result = new StringBuffer();
            msgFormat.format(this.buildTypedArguments(args, msgFormat.getFormatsByArgumentIndex()), result, new FieldPosition(0));
            return result.toString();
        }
        catch (IllegalArgumentException ex) {
            throw new LocalizationException("Invalid message template format", ex);
        }
    }

    Object[] buildTypedArguments(List<String> argValues, Format[] argFormats) {
        if (argValues == null) {
            return new Object[0];
        }
        Object[] result = new Object[argValues.size()];
        for (int i = 0; i < argValues.size(); ++i) {
            result[i] = this.convertToTypedArg(argValues.get(i), argFormats[i]);
        }
        return result;
    }

    Object convertToTypedArg(String argValue, Format argFormat) {
        if (argFormat == null) {
            return argValue;
        }
        if (argFormat instanceof SimpleDateFormat) {
            Calendar cal = this.argConverter.toCalendarArgument(argValue);
            return cal.getTime();
        }
        if (argFormat instanceof NumberFormat) {
            try {
                return this.argConverter.toLong(argValue);
            }
            catch (LocalizationException ex) {
                try {
                    return this.argConverter.toDouble(argValue);
                }
                catch (LocalizationException localizationException) {
                    throw new LocalizationException("Value doesn't match expected format type");
                }
            }
        }
        return argValue;
    }
}

