/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.l10n;

import com.vmware.vapi.l10n.LocalizationException;
import com.vmware.vapi.l10n.MessageArgConverter;
import com.vmware.vapi.l10n.TemplateFormatter;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public final class StringFormatTemplateFormatter
implements TemplateFormatter {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private final MessageArgConverter argConverter = new MessageArgConverter();

    @Override
    public String format(String msgTemplate, List<String> args, Locale locale) {
        Validate.notNull((Object)msgTemplate);
        Validate.notNull(args);
        Validate.notNull((Object)locale);
        Formatter formatter = new Formatter(locale);
        try {
            formatter.format(msgTemplate, this.buildTypedArguments(args, msgTemplate));
            return formatter.toString();
        }
        catch (RuntimeException ex) {
            throw new LocalizationException("Unable to format message template", ex);
        }
    }

    Object[] buildTypedArguments(List<String> argValues, String msgTemplate) {
        Object[] result = new Object[argValues.size()];
        List<FormatSpecifier> formats = this.parse(msgTemplate);
        int implicitArgIndex = 0;
        int argIndex = 0;
        for (FormatSpecifier fStr : formats) {
            if (fStr.getIndex() < 0 || result[argIndex = fStr.getIndex() > 0 ? fStr.getIndex() - 1 : implicitArgIndex++] != null) continue;
            result[argIndex] = this.buildTypedArg(fStr, argValues.get(argIndex));
        }
        return result;
    }

    Object buildTypedArg(FormatSpecifier fStr, String argValue) {
        if (Conversion.isInteger(fStr.getConversion())) {
            return this.argConverter.toLong(argValue);
        }
        if (Conversion.isFloat(fStr.getConversion())) {
            return this.argConverter.toDouble(argValue);
        }
        if (fStr.isDateTime) {
            return this.argConverter.toCalendarArgument(argValue);
        }
        return argValue;
    }

    List<FormatSpecifier> parse(String s) {
        LinkedList<FormatSpecifier> al = new LinkedList<FormatSpecifier>();
        Matcher m = fsPattern.matcher(s);
        int i = 0;
        while (i < s.length() && m.find(i)) {
            String[] tokens = new String[6];
            for (int j = 0; j < m.groupCount(); ++j) {
                tokens[j] = m.group(j + 1);
            }
            al.add(new FormatSpecifier(tokens));
            i = m.end();
        }
        return al;
    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char GENERAL = 'g';
        static final char GENERAL_UPPER = 'G';
        static final char DECIMAL_FLOAT = 'f';
        static final char HEXADECIMAL_FLOAT = 'a';
        static final char HEXADECIMAL_FLOAT_UPPER = 'A';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c) {
            return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
        }

        static boolean isGeneral(char c) {
            switch (c) {
                case 'B': 
                case 'S': 
                case 'b': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c) {
            switch (c) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c) {
            switch (c) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c) {
            switch (c) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c) {
            switch (c) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    class FormatSpecifier {
        private int index = -1;
        boolean isDateTime = false;
        private char c;

        FormatSpecifier(String[] tokens) {
            this.parseIndex(tokens[0]);
            if (tokens[4] != null) {
                this.isDateTime = true;
            }
            this.parseConversion(tokens[5]);
        }

        private void parseIndex(String s) {
            this.index = s != null ? Integer.parseInt(s.substring(0, s.length() - 1)) : 0;
        }

        public int getIndex() {
            return this.index;
        }

        private char parseConversion(String s) {
            this.c = s.charAt(0);
            if (!this.isDateTime) {
                if (!Conversion.isValid(this.c)) {
                    throw new UnknownFormatConversionException(String.valueOf(this.c));
                }
                this.c = Character.toLowerCase(this.c);
                if (Conversion.isText(this.c)) {
                    this.index = -2;
                }
            }
            return this.c;
        }

        private char getConversion() {
            return this.c;
        }
    }
}

