/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.vmware.vapi.security.AuthenticationConfig;
import com.vmware.vapi.security.AuthenticationFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;

public final class IniFileAuthenticationConfig
implements AuthenticationConfig {
    private static final String SERVICES_SECTION_NAME = "services";
    private static final String PACKAGES_SECTION_NAME = "packages";
    private static final String OPERATIONS_SECTION_NAME = "operations";
    private static final String AUTHENTICATION_SCHEME_KEY = "AuthenticationScheme";
    private static final String SESSIONFULL_TYPE_VALUE = "SessionFull";
    private static final String SCHEME_TYPE_KEY = "Type";
    private static final String SCHEME_PREFIX = "Scheme";
    private static final String LOAD_CONFIG_ERR_MSG = "Cannot load authentication config";
    private Map<String, List<AuthenticationConfig.AuthnScheme>> ifaceRulesTable;
    private Map<String, List<AuthenticationConfig.AuthnScheme>> packageRulesTable;
    private Map<String, List<AuthenticationConfig.AuthnScheme>> operationRulesTable;

    public IniFileAuthenticationConfig(String configFilename) {
        Validate.notEmpty((String)configFilename);
        this.loadConfig(configFilename);
    }

    @Override
    public Map<String, List<AuthenticationConfig.AuthnScheme>> getPackageAuthenticationRules() {
        return this.packageRulesTable;
    }

    @Override
    public Map<String, List<AuthenticationConfig.AuthnScheme>> getIFaceAuthenticationRules() {
        return this.ifaceRulesTable;
    }

    @Override
    public Map<String, List<AuthenticationConfig.AuthnScheme>> getOperationAuthenticationRules() {
        return this.operationRulesTable;
    }

    private void loadConfig(String authnConfig) {
        assert (authnConfig != null);
        InputStream iniStream = AuthenticationFilter.class.getResourceAsStream(authnConfig);
        try {
            Ini config = new Ini(iniStream);
            this.constructAuthnMap(config);
        }
        catch (InvalidFileFormatException e) {
            throw new IllegalArgumentException("Invalid authentication config file format", e);
        }
        catch (IOException e) {
            throw new RuntimeException(LOAD_CONFIG_ERR_MSG, e);
        }
        finally {
            try {
                iniStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(LOAD_CONFIG_ERR_MSG, e);
            }
        }
    }

    private void constructAuthnMap(Ini config) {
        assert (config != null);
        Map<String, AuthenticationConfig.AuthnScheme> schemes = this.loadSchemes(config);
        this.packageRulesTable = Collections.unmodifiableMap(this.loadConfigSection(config, schemes, PACKAGES_SECTION_NAME));
        this.ifaceRulesTable = Collections.unmodifiableMap(this.loadConfigSection(config, schemes, SERVICES_SECTION_NAME));
        this.operationRulesTable = Collections.unmodifiableMap(this.loadConfigSection(config, schemes, OPERATIONS_SECTION_NAME));
    }

    private Map<String, AuthenticationConfig.AuthnScheme> loadSchemes(Ini config) {
        assert (config != null);
        HashMap<String, AuthenticationConfig.AuthnScheme> schemeList = new HashMap<String, AuthenticationConfig.AuthnScheme>();
        for (String sectionName : config.keySet()) {
            if (!sectionName.startsWith(SCHEME_PREFIX)) continue;
            ArrayList<String> schemes = new ArrayList<String>();
            Profile.Section section = (Profile.Section)config.get((Object)sectionName);
            String schemeType = (String)section.get((Object)SCHEME_TYPE_KEY);
            Validate.notNull((Object)schemeType);
            if (schemeType.trim().equalsIgnoreCase(SESSIONFULL_TYPE_VALUE)) {
                schemes.add("com.vmware.vapi.std.security.session_id");
            }
            String scheme = (String)section.get((Object)AUTHENTICATION_SCHEME_KEY);
            Validate.notNull((Object)scheme);
            if (!scheme.trim().isEmpty()) {
                schemes.add(scheme);
            }
            schemeList.put(sectionName, new AuthenticationConfig.AuthnScheme(schemes));
        }
        return schemeList;
    }

    private Map<String, List<AuthenticationConfig.AuthnScheme>> loadConfigSection(Ini config, Map<String, AuthenticationConfig.AuthnScheme> schemes, String sectionName) {
        assert (config != null && schemes != null);
        HashMap<String, List<AuthenticationConfig.AuthnScheme>> result = new HashMap<String, List<AuthenticationConfig.AuthnScheme>>();
        for (String currentSectionName : config.keySet()) {
            if (!currentSectionName.trim().equalsIgnoreCase(sectionName)) continue;
            Profile.Section section = (Profile.Section)config.get((Object)currentSectionName);
            for (String ifaceName : section.keySet()) {
                String schemeListString = (String)section.get((Object)ifaceName);
                Validate.notNull((Object)schemeListString);
                ArrayList<AuthenticationConfig.AuthnScheme> schemeList = new ArrayList<AuthenticationConfig.AuthnScheme>();
                if (!schemeListString.trim().isEmpty()) {
                    this.parseSchemeList(schemes, schemeListString, schemeList);
                }
                result.put(ifaceName.trim().toLowerCase(Locale.ENGLISH), schemeList);
            }
        }
        return result;
    }

    private void parseSchemeList(Map<String, AuthenticationConfig.AuthnScheme> schemes, String schemeListString, List<AuthenticationConfig.AuthnScheme> schemeList) {
        for (String schemeName : schemeListString.split(",")) {
            AuthenticationConfig.AuthnScheme scheme = schemes.get(schemeName.trim());
            if (scheme == null) {
                throw new RuntimeException("Unknown scheme name found " + schemeName);
            }
            schemeList.add(scheme);
        }
    }
}

